/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.DataInput;
import java.io.IOException;
import java.util.Comparator;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataOutputPlus;

public class ReplayPosition
implements Comparable<ReplayPosition> {
    public static final ReplayPositionSerializer serializer = new ReplayPositionSerializer();
    public static final ReplayPosition NONE = new ReplayPosition(-1L, 0);
    public final long segment;
    public final int position;
    public static final Comparator<ReplayPosition> comparator = new Comparator<ReplayPosition>(){

        @Override
        public int compare(ReplayPosition o1, ReplayPosition o2) {
            if (o1.segment != o2.segment) {
                return Long.valueOf(o1.segment).compareTo(o2.segment);
            }
            return Integer.valueOf(o1.position).compareTo(o2.position);
        }
    };

    public static ReplayPosition getReplayPosition(Iterable<? extends SSTableReader> sstables) {
        if (Iterables.isEmpty(sstables)) {
            return NONE;
        }
        Function<SSTableReader, ReplayPosition> f = new Function<SSTableReader, ReplayPosition>(){

            @Override
            public ReplayPosition apply(SSTableReader sstable) {
                return sstable.getReplayPosition();
            }
        };
        Ordering<ReplayPosition> ordering = Ordering.from(comparator);
        return ordering.max(Iterables.transform(sstables, f));
    }

    public ReplayPosition(long segment, int position) {
        this.segment = segment;
        assert (position >= 0);
        this.position = position;
    }

    @Override
    public int compareTo(ReplayPosition other) {
        return comparator.compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayPosition that = (ReplayPosition)o;
        if (this.position != that.position) {
            return false;
        }
        return this.segment == that.segment;
    }

    public int hashCode() {
        int result = (int)(this.segment ^ this.segment >>> 32);
        result = 31 * result + this.position;
        return result;
    }

    public String toString() {
        return "ReplayPosition(segmentId=" + this.segment + ", position=" + this.position + ')';
    }

    public ReplayPosition clone() {
        return new ReplayPosition(this.segment, this.position);
    }

    public static class ReplayPositionSerializer
    implements ISerializer<ReplayPosition> {
        @Override
        public void serialize(ReplayPosition rp, DataOutputPlus out) throws IOException {
            out.writeLong(rp.segment);
            out.writeInt(rp.position);
        }

        @Override
        public ReplayPosition deserialize(DataInput in) throws IOException {
            return new ReplayPosition(in.readLong(), in.readInt());
        }

        @Override
        public long serializedSize(ReplayPosition rp, TypeSizes typeSizes) {
            return typeSizes.sizeof(rp.segment) + typeSizes.sizeof(rp.position);
        }
    }
}

