/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.UUIDGen;

public class Verifier
implements Closeable {
    private final ColumnFamilyStore cfs;
    private final SSTableReader sstable;
    private final CompactionController controller;
    private final RandomAccessReader dataFile;
    private final RandomAccessReader indexFile;
    private final VerifyInfo verifyInfo;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    private int goodRows;
    private int badRows;
    private final OutputHandler outputHandler;
    private DataIntegrityMetadata.FileDigestValidator validator;

    public Verifier(ColumnFamilyStore cfs, SSTableReader sstable, boolean isOffline) throws IOException {
        this(cfs, sstable, new OutputHandler.LogOutput(), isOffline);
    }

    public Verifier(ColumnFamilyStore cfs, SSTableReader sstable, OutputHandler outputHandler, boolean isOffline) throws IOException {
        this.cfs = cfs;
        this.sstable = sstable;
        this.outputHandler = outputHandler;
        this.rowIndexEntrySerializer = sstable.descriptor.version.getSSTableFormat().getIndexSerializer(sstable.metadata);
        this.controller = new VerifyController(cfs);
        this.dataFile = isOffline ? sstable.openDataReader() : sstable.openDataReader(CompactionManager.instance.getRateLimiter());
        this.indexFile = RandomAccessReader.open(new File(sstable.descriptor.filenameFor(Component.PRIMARY_INDEX)));
        this.verifyInfo = new VerifyInfo(this.dataFile, sstable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(boolean extended) throws IOException {
        long rowStart = 0L;
        this.outputHandler.output(String.format("Verifying %s (%s bytes)", this.sstable, this.dataFile.length()));
        this.outputHandler.output(String.format("Checking computed hash of %s ", this.sstable));
        try {
            this.validator = null;
            if (new File(this.sstable.descriptor.filenameFor(Component.DIGEST)).exists()) {
                this.validator = DataIntegrityMetadata.fileDigestValidator(this.sstable.descriptor);
                this.validator.validate();
            } else {
                this.outputHandler.output("Data digest missing, assuming extended verification of disk atoms");
                extended = true;
            }
        }
        catch (IOException e) {
            this.outputHandler.debug(e.getMessage());
            this.markAndThrow();
        }
        finally {
            FileUtils.closeQuietly(this.validator);
        }
        if (!extended) {
            return;
        }
        this.outputHandler.output("Extended Verify requested, proceeding to inspect atoms");
        try {
            ByteBuffer nextIndexKey = ByteBufferUtil.readWithShortLength(this.indexFile);
            long firstRowPositionFromIndex = this.rowIndexEntrySerializer.deserialize((DataInput)this.indexFile, (Version)this.sstable.descriptor.version).position;
            if (firstRowPositionFromIndex != 0L) {
                this.markAndThrow();
            }
            DecoratedKey prevKey = null;
            while (!this.dataFile.isEOF()) {
                if (this.verifyInfo.isStopRequested()) {
                    throw new CompactionInterruptedException(this.verifyInfo.getCompactionInfo());
                }
                rowStart = this.dataFile.getFilePointer();
                this.outputHandler.debug("Reading row at " + rowStart);
                DecoratedKey key = null;
                try {
                    key = this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.dataFile));
                }
                catch (Throwable th) {
                    this.throwIfFatal(th);
                }
                ByteBuffer currentIndexKey = nextIndexKey;
                long nextRowPositionFromIndex = 0L;
                try {
                    nextIndexKey = this.indexFile.isEOF() ? null : ByteBufferUtil.readWithShortLength(this.indexFile);
                    nextRowPositionFromIndex = this.indexFile.isEOF() ? this.dataFile.length() : this.rowIndexEntrySerializer.deserialize((DataInput)this.indexFile, (Version)this.sstable.descriptor.version).position;
                }
                catch (Throwable th) {
                    this.markAndThrow();
                }
                long dataStart = this.dataFile.getFilePointer();
                long dataStartFromIndex = currentIndexKey == null ? -1L : rowStart + 2L + (long)currentIndexKey.remaining();
                long dataSize = nextRowPositionFromIndex - dataStartFromIndex;
                String keyName = key == null ? "(unreadable key)" : ByteBufferUtil.bytesToHex(key.getKey());
                this.outputHandler.debug(String.format("row %s is %s bytes", keyName, dataSize));
                assert (currentIndexKey != null || this.indexFile.isEOF());
                try {
                    if (key == null || dataSize > this.dataFile.length()) {
                        this.markAndThrow();
                    }
                    new SSTableIdentityIterator(this.sstable, this.dataFile, key, true);
                    if (prevKey != null && prevKey.compareTo(key) > 0 || !key.getKey().equals(currentIndexKey) || dataStart != dataStartFromIndex) {
                        this.markAndThrow();
                    }
                    ++this.goodRows;
                    prevKey = key;
                    this.outputHandler.debug(String.format("Row %s at %s valid, moving to next row at %s ", this.goodRows, rowStart, nextRowPositionFromIndex));
                    this.dataFile.seek(nextRowPositionFromIndex);
                }
                catch (Throwable th) {
                    ++this.badRows;
                    this.markAndThrow();
                }
            }
        }
        catch (Throwable t) {
            throw Throwables.propagate(t);
        }
        finally {
            this.controller.close();
        }
        this.outputHandler.output("Verify of " + this.sstable + " succeeded. All " + this.goodRows + " rows read successfully");
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.dataFile);
        FileUtils.closeQuietly(this.indexFile);
    }

    private void throwIfFatal(Throwable th) {
        if (th instanceof Error && !(th instanceof AssertionError) && !(th instanceof IOError)) {
            throw (Error)th;
        }
    }

    private void markAndThrow() throws IOException {
        this.sstable.descriptor.getMetadataSerializer().mutateRepairedAt(this.sstable.descriptor, 0L);
        throw new CorruptSSTableException(new Exception(String.format("Invalid SSTable %s, please force repair", this.sstable.getFilename())), this.sstable.getFilename());
    }

    public CompactionInfo.Holder getVerifyInfo() {
        return this.verifyInfo;
    }

    private static class VerifyController
    extends CompactionController {
        public VerifyController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MAX_VALUE);
        }

        @Override
        public long maxPurgeableTimestamp(DecoratedKey key) {
            return Long.MIN_VALUE;
        }
    }

    private static class VerifyInfo
    extends CompactionInfo.Holder {
        private final RandomAccessReader dataFile;
        private final SSTableReader sstable;
        private final UUID verificationCompactionId;

        public VerifyInfo(RandomAccessReader dataFile, SSTableReader sstable) {
            this.dataFile = dataFile;
            this.sstable = sstable;
            this.verificationCompactionId = UUIDGen.getTimeUUID();
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            try {
                return new CompactionInfo(this.sstable.metadata, OperationType.VERIFY, this.dataFile.getFilePointer(), this.dataFile.length(), this.verificationCompactionId);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }
}

