/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.serializers.MapSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtendedFilter {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedFilter.class);
    public final ColumnFamilyStore cfs;
    public final long timestamp;
    public final DataRange dataRange;
    private final int maxResults;
    private final boolean countCQL3Rows;
    private volatile int currentLimit;

    public static ExtendedFilter create(ColumnFamilyStore cfs, DataRange dataRange, List<IndexExpression> clause, int maxResults, boolean countCQL3Rows, long timestamp) {
        if (clause == null || clause.isEmpty()) {
            return new EmptyClauseFilter(cfs, dataRange, maxResults, countCQL3Rows, timestamp);
        }
        return new WithClauses(cfs, dataRange, clause, maxResults, countCQL3Rows, timestamp);
    }

    protected ExtendedFilter(ColumnFamilyStore cfs, DataRange dataRange, int maxResults, boolean countCQL3Rows, long timestamp) {
        assert (cfs != null);
        assert (dataRange != null);
        this.cfs = cfs;
        this.dataRange = dataRange;
        this.maxResults = maxResults;
        this.timestamp = timestamp;
        this.countCQL3Rows = countCQL3Rows;
        this.currentLimit = maxResults;
        if (countCQL3Rows) {
            dataRange.updateColumnsLimit(maxResults);
        }
    }

    public int maxRows() {
        return this.countCQL3Rows ? Integer.MAX_VALUE : this.maxResults;
    }

    public int maxColumns() {
        return this.countCQL3Rows ? this.maxResults : Integer.MAX_VALUE;
    }

    public int currentLimit() {
        return this.currentLimit;
    }

    public IDiskAtomFilter columnFilter(ByteBuffer key) {
        return this.dataRange.columnFilter(key);
    }

    public int lastCounted(ColumnFamily data) {
        return this.dataRange.getLiveCount(data, this.timestamp);
    }

    public void updateFilter(int currentColumnsCount) {
        if (!this.countCQL3Rows) {
            return;
        }
        this.currentLimit = this.maxResults - currentColumnsCount;
        this.dataRange.updateColumnsLimit(this.currentLimit);
    }

    public abstract List<IndexExpression> getClause();

    public abstract IDiskAtomFilter getExtraFilter(DecoratedKey var1, ColumnFamily var2);

    public abstract ColumnFamily prune(DecoratedKey var1, ColumnFamily var2);

    public boolean ignoreTombstonedPartitions() {
        return this.dataRange.ignoredTombstonedPartitions();
    }

    public abstract boolean isSatisfiedBy(DecoratedKey var1, ColumnFamily var2, Composite var3, ByteBuffer var4);

    public static boolean satisfies(int comparison, Operator op) {
        switch (op) {
            case EQ: {
                return comparison == 0;
            }
            case GTE: {
                return comparison >= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case LTE: {
                return comparison <= 0;
            }
            case LT: {
                return comparison < 0;
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("dataRange", this.dataRange).add("maxResults", this.maxResults).add("currentLimit", this.currentLimit).add("timestamp", this.timestamp).add("countCQL3Rows", this.countCQL3Rows).toString();
    }

    private static class EmptyClauseFilter
    extends ExtendedFilter {
        public EmptyClauseFilter(ColumnFamilyStore cfs, DataRange range, int maxResults, boolean countCQL3Rows, long timestamp) {
            super(cfs, range, maxResults, countCQL3Rows, timestamp);
        }

        @Override
        public List<IndexExpression> getClause() {
            return Collections.emptyList();
        }

        @Override
        public IDiskAtomFilter getExtraFilter(DecoratedKey key, ColumnFamily data) {
            return null;
        }

        @Override
        public ColumnFamily prune(DecoratedKey rowKey, ColumnFamily data) {
            return data;
        }

        @Override
        public boolean isSatisfiedBy(DecoratedKey rowKey, ColumnFamily data, Composite prefix, ByteBuffer collectionElement) {
            return true;
        }
    }

    public static class WithClauses
    extends ExtendedFilter {
        private final List<IndexExpression> clause;
        private final IDiskAtomFilter optimizedFilter;

        public WithClauses(ColumnFamilyStore cfs, DataRange range, List<IndexExpression> clause, int maxResults, boolean countCQL3Rows, long timestamp) {
            super(cfs, range, maxResults, countCQL3Rows, timestamp);
            assert (clause != null);
            this.clause = clause;
            this.optimizedFilter = this.computeOptimizedFilter();
        }

        private IDiskAtomFilter computeOptimizedFilter() {
            if (this.cfs.getComparator().isCompound() || this.dataRange instanceof DataRange.Paging) {
                return null;
            }
            IDiskAtomFilter filter = this.dataRange.columnFilter(null);
            if (filter instanceof SliceQueryFilter) {
                if (this.cfs.metric.maxRowSize.getValue() < (long)DatabaseDescriptor.getColumnIndexSize()) {
                    logger.trace("Expanding slice filter to entire row to cover additional expressions");
                    return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, ((SliceQueryFilter)filter).reversed, Integer.MAX_VALUE);
                }
            } else {
                logger.trace("adding columns to original Filter to cover additional expressions");
                assert (filter instanceof NamesQueryFilter);
                if (!this.clause.isEmpty()) {
                    TreeSet<Composite> columns = new TreeSet<Composite>(this.cfs.getComparator());
                    for (IndexExpression expr : this.clause) {
                        columns.add(this.cfs.getComparator().cellFromByteBuffer(expr.column));
                    }
                    columns.addAll(((NamesQueryFilter)filter).columns);
                    return ((NamesQueryFilter)filter).withUpdatedColumns(columns);
                }
            }
            return null;
        }

        @Override
        public IDiskAtomFilter columnFilter(ByteBuffer key) {
            return this.optimizedFilter == null ? this.dataRange.columnFilter(key) : this.optimizedFilter;
        }

        @Override
        public List<IndexExpression> getClause() {
            return this.clause;
        }

        private boolean needsExtraQuery(ByteBuffer rowKey, ColumnFamily data) {
            IDiskAtomFilter filter = this.columnFilter(rowKey);
            if (filter instanceof SliceQueryFilter && DataRange.isFullRowSlice((SliceQueryFilter)filter)) {
                return false;
            }
            for (IndexExpression expr : this.clause) {
                if (data.getColumn(data.getComparator().cellFromByteBuffer(expr.column)) != null) continue;
                logger.trace("adding extraFilter to cover additional expressions");
                return true;
            }
            return false;
        }

        @Override
        public IDiskAtomFilter getExtraFilter(DecoratedKey rowKey, ColumnFamily data) {
            assert (!this.cfs.getComparator().isCompound()) : "Sequential scan with filters is not supported (if you just created an index, you need to wait for the creation to be propagated to all nodes before querying it)";
            if (!this.needsExtraQuery(rowKey.getKey(), data)) {
                return null;
            }
            TreeSet<Composite> columns = new TreeSet<Composite>(this.cfs.getComparator());
            for (IndexExpression expr : this.clause) {
                CellName name = data.getComparator().cellFromByteBuffer(expr.column);
                if (data.getColumn(name) != null) continue;
                columns.add(name);
            }
            assert (!columns.isEmpty());
            return new NamesQueryFilter(columns);
        }

        @Override
        public ColumnFamily prune(DecoratedKey rowKey, ColumnFamily data) {
            if (this.optimizedFilter == null) {
                return data;
            }
            ColumnFamily pruned = data.cloneMeShallow();
            IDiskAtomFilter filter = this.dataRange.columnFilter(rowKey.getKey());
            Iterator<Cell> iter2 = filter.getColumnIterator(data);
            try {
                filter.collectReducedColumns(pruned, QueryFilter.gatherTombstones(pruned, iter2), rowKey, this.cfs.gcBefore(this.timestamp), this.timestamp);
            }
            catch (TombstoneOverwhelmingException e) {
                e.setKey(rowKey);
                throw e;
            }
            return pruned;
        }

        @Override
        public boolean isSatisfiedBy(DecoratedKey rowKey, ColumnFamily data, Composite prefix, ByteBuffer collectionElement) {
            for (IndexExpression expression : this.clause) {
                ColumnDefinition def = data.metadata().getColumnDefinition(expression.column);
                ByteBuffer dataValue = null;
                AbstractType<?> validator = null;
                if (def == null) {
                    Cell cell = data.getColumn(data.getComparator().cellFromByteBuffer(expression.column));
                    if (cell != null) {
                        dataValue = cell.value();
                        validator = data.metadata().getDefaultValidator();
                    }
                } else {
                    if (def.type.isCollection() && def.type.isMultiCell()) {
                        if (WithClauses.collectionSatisfies(def, data, prefix, expression)) continue;
                        return false;
                    }
                    dataValue = this.extractDataValue(def, rowKey.getKey(), data, prefix);
                    validator = def.type;
                }
                if (dataValue == null) {
                    return false;
                }
                if (expression.operator == Operator.CONTAINS) {
                    assert (def != null && def.type.isCollection() && !def.type.isMultiCell());
                    CollectionType type = (CollectionType)def.type;
                    switch (type.kind) {
                        case LIST: {
                            ListType listType = (ListType)def.type;
                            if (((List)listType.getSerializer().deserialize(dataValue)).contains(listType.getElementsType().getSerializer().deserialize(expression.value))) break;
                            return false;
                        }
                        case SET: {
                            SetType setType = (SetType)def.type;
                            if (((Set)setType.getSerializer().deserialize(dataValue)).contains(setType.getElementsType().getSerializer().deserialize(expression.value))) break;
                            return false;
                        }
                        case MAP: {
                            MapType mapType = (MapType)def.type;
                            if (((Map)mapType.getSerializer().deserialize(dataValue)).containsValue(mapType.getValuesType().getSerializer().deserialize(expression.value))) break;
                            return false;
                        }
                    }
                    continue;
                }
                if (expression.operator == Operator.CONTAINS_KEY) {
                    assert (def != null && def.type.isCollection() && !def.type.isMultiCell() && def.type instanceof MapType);
                    MapType mapType = (MapType)def.type;
                    if (((MapSerializer)mapType.getSerializer()).getSerializedValue(dataValue, expression.value, mapType.getKeysType()) != null) continue;
                    return false;
                }
                int v = validator.compare(dataValue, expression.value);
                if (WithClauses.satisfies(v, expression.operator)) continue;
                return false;
            }
            return true;
        }

        private static boolean collectionSatisfies(ColumnDefinition def, ColumnFamily data, Composite prefix, IndexExpression expr) {
            assert (def.type.isCollection() && def.type.isMultiCell());
            CollectionType type = (CollectionType)def.type;
            if (expr.isContains()) {
                Iterator<Cell> iter2 = data.iterator(new ColumnSlice[]{data.getComparator().create(prefix, def).slice()});
                while (iter2.hasNext()) {
                    Cell cell = iter2.next();
                    if (!(type.kind == CollectionType.Kind.SET ? type.nameComparator().compare(cell.name().collectionElement(), expr.value) == 0 : type.valueComparator().compare(cell.value(), expr.value) == 0)) continue;
                    return true;
                }
                return false;
            }
            assert (type.kind == CollectionType.Kind.MAP);
            if (expr.isContainsKey()) {
                return data.getColumn(data.getComparator().create(prefix, def, expr.value)) != null;
            }
            Iterator<Cell> iter3 = data.iterator(new ColumnSlice[]{data.getComparator().create(prefix, def).slice()});
            ByteBuffer key = CompositeType.extractComponent(expr.value, 0);
            ByteBuffer value = CompositeType.extractComponent(expr.value, 1);
            while (iter3.hasNext()) {
                Cell next = iter3.next();
                if (type.nameComparator().compare(next.name().collectionElement(), key) != 0 || type.valueComparator().compare(next.value(), value) != 0) continue;
                return true;
            }
            return false;
        }

        private ByteBuffer extractDataValue(ColumnDefinition def, ByteBuffer rowKey, ColumnFamily data, Composite prefix) {
            switch (def.kind) {
                case PARTITION_KEY: {
                    return def.isOnAllComponents() ? rowKey : ((CompositeType)data.metadata().getKeyValidator()).split(rowKey)[def.position()];
                }
                case CLUSTERING_COLUMN: {
                    return prefix.get(def.position());
                }
                case REGULAR: {
                    CellName cname = prefix == null ? data.getComparator().cellFromByteBuffer(def.name.bytes) : data.getComparator().create(prefix, def);
                    Cell cell = data.getColumn(cname);
                    return cell == null ? null : cell.value();
                }
                case COMPACT_VALUE: {
                    assert (data.getColumnCount() == 1);
                    return data.getSortedColumns().iterator().next().value();
                }
            }
            throw new AssertionError();
        }

        @Override
        public String toString() {
            return Objects.toStringHelper(this).add("dataRange", this.dataRange).add("timestamp", this.timestamp).add("clause", this.clause).toString();
        }
    }
}

