/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerRowSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryIndexManager {
    private static final Logger logger = LoggerFactory.getLogger(SecondaryIndexManager.class);
    public static final Updater nullUpdater = new Updater(){

        @Override
        public void insert(Cell cell) {
        }

        @Override
        public void update(Cell oldCell, Cell cell) {
        }

        @Override
        public void remove(Cell current) {
        }

        @Override
        public void updateRowLevelIndexes() {
        }
    };
    private final ConcurrentNavigableMap<ByteBuffer, SecondaryIndex> indexesByColumn = new ConcurrentSkipListMap<ByteBuffer, SecondaryIndex>();
    private final ConcurrentMap<Class<? extends SecondaryIndex>, SecondaryIndex> rowLevelIndexMap = new ConcurrentHashMap<Class<? extends SecondaryIndex>, SecondaryIndex>();
    private final Collection<SecondaryIndex> allIndexes;
    private final Map<String, SecondaryIndex> indexesByName = new ConcurrentHashMap<String, SecondaryIndex>();
    public final ColumnFamilyStore baseCfs;

    public SecondaryIndexManager(ColumnFamilyStore baseCfs) {
        this.allIndexes = this.indexesByName.values();
        this.baseCfs = baseCfs;
    }

    public void reload() {
        Set indexedColumnNames = this.indexesByColumn.keySet();
        for (ByteBuffer indexedColumn : indexedColumnNames) {
            ColumnDefinition def = this.baseCfs.metadata.getColumnDefinition(indexedColumn);
            if (def != null && def.getIndexType() != null) continue;
            this.removeIndexedColumn(indexedColumn);
        }
        for (ColumnDefinition cdef : this.baseCfs.metadata.allColumns()) {
            if (cdef.getIndexType() == null || indexedColumnNames.contains(cdef.name.bytes)) continue;
            this.addIndexedColumn(cdef);
        }
        for (SecondaryIndex index : this.allIndexes) {
            index.reload();
        }
    }

    public Set<String> allIndexesNames() {
        HashSet<String> names = new HashSet<String>(this.allIndexes.size());
        for (SecondaryIndex index : this.allIndexes) {
            names.add(index.getIndexName());
        }
        return names;
    }

    public void maybeBuildSecondaryIndexes(Collection<SSTableReader> sstables, Set<String> idxNames) {
        if ((idxNames = this.filterByColumn(idxNames)).isEmpty()) {
            return;
        }
        logger.info(String.format("Submitting index build of %s for data in %s", idxNames, StringUtils.join(sstables, ", ")));
        SecondaryIndexBuilder builder = new SecondaryIndexBuilder(this.baseCfs, idxNames, new ReducingKeyIterator(sstables));
        Future<?> future = CompactionManager.instance.submitIndexBuild(builder);
        FBUtilities.waitOnFuture(future);
        this.flushIndexesBlocking();
        logger.info("Index build of {} complete", (Object)idxNames);
    }

    public boolean indexes(CellName name, Collection<SecondaryIndex> indexes) {
        boolean matching = false;
        for (SecondaryIndex index : indexes) {
            if (!index.indexes(name)) continue;
            matching = true;
            break;
        }
        return matching;
    }

    public Set<SecondaryIndex> indexFor(CellName name, Collection<SecondaryIndex> indexes) {
        HashSet<SecondaryIndex> matching = null;
        for (SecondaryIndex index : indexes) {
            if (!index.indexes(name)) continue;
            if (matching == null) {
                matching = new HashSet<SecondaryIndex>();
            }
            matching.add(index);
        }
        return matching == null ? Collections.emptySet() : matching;
    }

    public boolean indexes(Cell cell) {
        return this.indexes(cell.name());
    }

    public boolean indexes(CellName name) {
        return this.indexes(name, this.allIndexes);
    }

    public Set<SecondaryIndex> indexFor(CellName name) {
        return this.indexFor(name, this.allIndexes);
    }

    public boolean hasIndexFor(List<IndexExpression> clause) {
        if (clause == null || clause.isEmpty()) {
            return false;
        }
        for (SecondaryIndexSearcher searcher : this.getIndexSearchersForQuery(clause)) {
            if (!searcher.canHandleIndexClause(clause)) continue;
            return true;
        }
        return false;
    }

    public void removeIndexedColumn(ByteBuffer column) {
        SecondaryIndex index = (SecondaryIndex)this.indexesByColumn.remove(column);
        if (index == null) {
            return;
        }
        if (index instanceof PerRowSecondaryIndex) {
            index.removeColumnDef(column);
            if (index.getColumnDefs().isEmpty()) {
                this.allIndexes.remove(index);
                this.rowLevelIndexMap.remove(index.getClass());
            }
        } else {
            this.allIndexes.remove(index);
        }
        index.removeIndex(column);
        SystemKeyspace.setIndexRemoved(this.baseCfs.metadata.ksName, index.getNameForSystemKeyspace(column));
    }

    public synchronized Future<?> addIndexedColumn(ColumnDefinition cdef) {
        if (this.indexesByColumn.containsKey(cdef.name.bytes)) {
            return null;
        }
        assert (cdef.getIndexType() != null);
        SecondaryIndex index = SecondaryIndex.createInstance(this.baseCfs, cdef);
        if (index instanceof PerRowSecondaryIndex) {
            SecondaryIndex currentIndex = (SecondaryIndex)this.rowLevelIndexMap.get(index.getClass());
            if (currentIndex == null) {
                this.rowLevelIndexMap.put(index.getClass(), index);
                index.init();
            } else {
                index = currentIndex;
                index.addColumnDef(cdef);
                logger.info("Creating new index : {}", (Object)cdef);
            }
        } else {
            if (cdef.getIndexType() == IndexType.CUSTOM && index instanceof AbstractSimplePerColumnSecondaryIndex) {
                throw new RuntimeException("Cannot use a subclass of AbstractSimplePerColumnSecondaryIndex as a CUSTOM index, as they assume they are CFS backed");
            }
            index.init();
        }
        this.indexesByColumn.put(cdef.name.bytes, index);
        this.indexesByName.put(index.getIndexName(), index);
        if (index.isIndexBuilt(cdef.name.bytes)) {
            return null;
        }
        return index.buildIndexAsync();
    }

    public SecondaryIndex getIndexForColumn(ByteBuffer column) {
        return (SecondaryIndex)this.indexesByColumn.get(column);
    }

    public void invalidate() {
        for (SecondaryIndex index : this.allIndexes) {
            index.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushIndexesBlocking() {
        ArrayList wait = new ArrayList();
        Tracker tracker = this.baseCfs.getTracker();
        synchronized (tracker) {
            for (SecondaryIndex index : this.allIndexes) {
                if (index.getIndexCfs() == null) continue;
                wait.add(index.getIndexCfs().forceFlush());
            }
        }
        for (SecondaryIndex index : this.allIndexes) {
            if (index.getIndexCfs() != null) continue;
            index.forceBlockingFlush();
        }
        FBUtilities.waitOnFutures(wait);
    }

    public List<String> getBuiltIndexes() {
        ArrayList<String> indexList = new ArrayList<String>();
        for (Map.Entry entry : this.indexesByColumn.entrySet()) {
            SecondaryIndex index = (SecondaryIndex)entry.getValue();
            if (!index.isIndexBuilt((ByteBuffer)entry.getKey())) continue;
            indexList.add(((SecondaryIndex)entry.getValue()).getIndexName());
        }
        return indexList;
    }

    public Set<ColumnFamilyStore> getIndexesBackedByCfs() {
        HashSet<ColumnFamilyStore> cfsList = new HashSet<ColumnFamilyStore>();
        for (SecondaryIndex index : this.allIndexes) {
            ColumnFamilyStore cfs = index.getIndexCfs();
            if (cfs == null) continue;
            cfsList.add(cfs);
        }
        return cfsList;
    }

    public Set<SecondaryIndex> getIndexesNotBackedByCfs() {
        Set<SecondaryIndex> indexes = Collections.newSetFromMap(new IdentityHashMap());
        for (SecondaryIndex index : this.allIndexes) {
            if (index.getIndexCfs() != null) continue;
            indexes.add(index);
        }
        return indexes;
    }

    public Collection<SecondaryIndex> getIndexes() {
        return this.allIndexes;
    }

    public SecondaryIndex getIndexByName(String name) {
        return this.indexesByName.get(name);
    }

    public boolean hasIndexes() {
        return !this.indexesByColumn.isEmpty();
    }

    public void indexRow(ByteBuffer key, ColumnFamily cf, OpOrder.Group opGroup) {
        HashSet appliedRowLevelIndexes = null;
        for (SecondaryIndex index : this.allIndexes) {
            if (index instanceof PerRowSecondaryIndex) {
                if (appliedRowLevelIndexes == null) {
                    appliedRowLevelIndexes = new HashSet();
                }
                if (!appliedRowLevelIndexes.add(index.getClass())) continue;
                ((PerRowSecondaryIndex)index).index(key, cf);
                continue;
            }
            for (Cell cell : cf) {
                if (!cell.isLive() || !index.indexes(cell.name())) continue;
                ((PerColumnSecondaryIndex)index).insert(key, cell, opGroup);
            }
        }
    }

    public void deleteFromIndexes(DecoratedKey key, List<Cell> indexedColumnsInRow, OpOrder.Group opGroup) {
        HashSet cleanedRowLevelIndexes = null;
        for (Cell cell : indexedColumnsInRow) {
            for (SecondaryIndex index : this.indexFor(cell.name())) {
                if (index instanceof PerRowSecondaryIndex) {
                    if (cleanedRowLevelIndexes == null) {
                        cleanedRowLevelIndexes = new HashSet();
                    }
                    if (!cleanedRowLevelIndexes.add(index.getClass())) continue;
                    ((PerRowSecondaryIndex)index).delete(key, opGroup);
                    continue;
                }
                ((PerColumnSecondaryIndex)index).deleteForCleanup(key.getKey(), cell, opGroup);
            }
        }
    }

    public Updater updaterFor(DecoratedKey key, ColumnFamily cf, OpOrder.Group opGroup) {
        return this.indexesByColumn.isEmpty() && this.rowLevelIndexMap.isEmpty() ? nullUpdater : new StandardUpdater(key, cf, opGroup);
    }

    public Updater gcUpdaterFor(DecoratedKey key) {
        return new GCUpdater(key);
    }

    public List<SecondaryIndexSearcher> getIndexSearchersForQuery(List<IndexExpression> clause) {
        HashMap<String, HashSet<ByteBuffer>> groupByIndexType = new HashMap<String, HashSet<ByteBuffer>>();
        for (IndexExpression ix : clause) {
            SecondaryIndex index = this.getIndexForColumn(ix.column);
            if (index == null || !index.supportsOperator(ix.operator)) continue;
            HashSet<ByteBuffer> columns = (HashSet<ByteBuffer>)groupByIndexType.get(index.indexTypeForGrouping());
            if (columns == null) {
                columns = new HashSet<ByteBuffer>();
                groupByIndexType.put(index.indexTypeForGrouping(), columns);
            }
            columns.add(ix.column);
        }
        ArrayList<SecondaryIndexSearcher> indexSearchers = new ArrayList<SecondaryIndexSearcher>(groupByIndexType.size());
        for (Set column : groupByIndexType.values()) {
            indexSearchers.add(this.getIndexForColumn((ByteBuffer)column.iterator().next()).createSecondaryIndexSearcher(column));
        }
        return indexSearchers;
    }

    /*
     * WARNING - void declaration
     */
    public void validateIndexSearchersForQuery(List<IndexExpression> clause) throws InvalidRequestException {
        HashMap expressionsByIndexType = new HashMap();
        HashMap<String, HashSet<ByteBuffer>> columnsByIndexType = new HashMap<String, HashSet<ByteBuffer>>();
        for (IndexExpression indexExpression : clause) {
            void var8_15;
            SecondaryIndex secondaryIndex = this.getIndexForColumn(indexExpression.column);
            if (secondaryIndex == null) continue;
            String canonicalIndexName = secondaryIndex.getClass().getCanonicalName();
            Set set = (Set)expressionsByIndexType.get(canonicalIndexName);
            HashSet<ByteBuffer> columns = (HashSet<ByteBuffer>)columnsByIndexType.get(canonicalIndexName);
            if (set == null) {
                HashSet hashSet = new HashSet();
                columns = new HashSet<ByteBuffer>();
                expressionsByIndexType.put(canonicalIndexName, hashSet);
                columnsByIndexType.put(canonicalIndexName, columns);
            }
            var8_15.add(indexExpression);
            columns.add(indexExpression.column);
        }
        boolean haveSupportedIndexLookup = false;
        for (Map.Entry entry : expressionsByIndexType.entrySet()) {
            Set columns = (Set)columnsByIndexType.get(entry.getKey());
            SecondaryIndex secondaryIndex = this.getIndexForColumn((ByteBuffer)columns.iterator().next());
            SecondaryIndexSearcher searcher = secondaryIndex.createSecondaryIndexSearcher(columns);
            for (IndexExpression expression : (Set)entry.getValue()) {
                searcher.validate(expression);
                haveSupportedIndexLookup |= secondaryIndex.supportsOperator(expression.operator);
            }
        }
        if (!haveSupportedIndexLookup) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder("No secondary indexes on the restricted columns support the provided operators: ");
            for (Map.Entry entry : expressionsByIndexType.entrySet()) {
                for (IndexExpression expression : (Set)entry.getValue()) {
                    String columnName;
                    void var5_9;
                    if (++var5_9 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("'");
                    try {
                        columnName = ByteBufferUtil.string(expression.column);
                    }
                    catch (CharacterCodingException ex) {
                        columnName = "<unprintable>";
                    }
                    stringBuilder.append(columnName).append(" ").append((Object)expression.operator).append(" <value>").append("'");
                }
            }
            throw new InvalidRequestException(stringBuilder.toString());
        }
    }

    public List<Row> search(ExtendedFilter filter) {
        SecondaryIndexSearcher mostSelective = this.getHighestSelectivityIndexSearcher(filter.getClause());
        if (mostSelective == null) {
            return Collections.emptyList();
        }
        return mostSelective.search(filter);
    }

    public Set<SecondaryIndex> getIndexesByNames(Set<String> idxNames) {
        HashSet<SecondaryIndex> result = new HashSet<SecondaryIndex>();
        for (SecondaryIndex index : this.allIndexes) {
            if (!idxNames.contains(index.getIndexName())) continue;
            result.add(index);
        }
        return result;
    }

    public void setIndexBuilt(Set<String> idxNames) {
        for (SecondaryIndex index : this.getIndexesByNames(idxNames)) {
            index.setIndexBuilt();
        }
    }

    public void setIndexRemoved(Set<String> idxNames) {
        for (SecondaryIndex index : this.getIndexesByNames(idxNames)) {
            index.setIndexRemoved();
        }
    }

    public SecondaryIndex validate(ByteBuffer rowKey, Cell cell) {
        for (SecondaryIndex index : this.indexFor(cell.name())) {
            if (index.validate(rowKey, cell)) continue;
            return index;
        }
        return null;
    }

    static boolean shouldCleanupOldValue(Cell oldCell, Cell newCell) {
        return !oldCell.name().equals(newCell.name()) || !oldCell.value().equals(newCell.value()) || oldCell.timestamp() != newCell.timestamp();
    }

    private Set<String> filterByColumn(Set<String> idxNames) {
        Set<SecondaryIndex> indexes = this.getIndexesByNames(idxNames);
        HashSet<String> filtered = new HashSet<String>(idxNames.size());
        block0: for (SecondaryIndex candidate : indexes) {
            for (ColumnDefinition column : this.baseCfs.metadata.allColumns()) {
                if (!candidate.indexes(column)) continue;
                filtered.add(candidate.getIndexName());
                continue block0;
            }
        }
        return filtered;
    }

    public SecondaryIndexSearcher getHighestSelectivityIndexSearcher(List<IndexExpression> clause) {
        if (clause == null) {
            return null;
        }
        List<SecondaryIndexSearcher> indexSearchers = this.getIndexSearchersForQuery(clause);
        if (indexSearchers.isEmpty()) {
            return null;
        }
        SecondaryIndexSearcher mostSelective = null;
        long bestEstimate = Long.MAX_VALUE;
        for (SecondaryIndexSearcher searcher : indexSearchers) {
            SecondaryIndex highestSelectivityIndex = searcher.highestSelectivityIndex(clause);
            long estimate = highestSelectivityIndex.estimateResultRows();
            if (estimate > bestEstimate) continue;
            bestEstimate = estimate;
            mostSelective = searcher;
        }
        return mostSelective;
    }

    private final class StandardUpdater
    implements Updater {
        private final DecoratedKey key;
        private final ColumnFamily cf;
        private final OpOrder.Group opGroup;

        public StandardUpdater(DecoratedKey key, ColumnFamily cf, OpOrder.Group opGroup) {
            this.key = key;
            this.cf = cf;
            this.opGroup = opGroup;
        }

        @Override
        public void insert(Cell cell) {
            if (!cell.isLive()) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.name())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                ((PerColumnSecondaryIndex)index).insert(this.key.getKey(), cell, this.opGroup);
            }
        }

        @Override
        public void update(Cell oldCell, Cell cell) {
            if (oldCell.equals(cell)) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.name())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                if (cell.isLive()) {
                    ((PerColumnSecondaryIndex)index).update(this.key.getKey(), oldCell, cell, this.opGroup);
                    continue;
                }
                if (!SecondaryIndexManager.shouldCleanupOldValue(oldCell, cell)) continue;
                ((PerColumnSecondaryIndex)index).delete(this.key.getKey(), oldCell, this.opGroup);
            }
        }

        @Override
        public void remove(Cell cell) {
            if (!cell.isLive()) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.name())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                ((PerColumnSecondaryIndex)index).delete(this.key.getKey(), cell, this.opGroup);
            }
        }

        @Override
        public void updateRowLevelIndexes() {
            for (SecondaryIndex index : SecondaryIndexManager.this.rowLevelIndexMap.values()) {
                ((PerRowSecondaryIndex)index).index(this.key.getKey(), this.cf);
            }
        }
    }

    private final class GCUpdater
    implements Updater {
        private final DecoratedKey key;

        public GCUpdater(DecoratedKey key) {
            this.key = key;
        }

        @Override
        public void insert(Cell cell) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(Cell oldCell, Cell newCell) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Cell cell) {
            if (!cell.isLive()) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.name())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                OpOrder.Group opGroup = SecondaryIndexManager.this.baseCfs.keyspace.writeOrder.start();
                Throwable throwable = null;
                try {
                    ((PerColumnSecondaryIndex)index).delete(this.key.getKey(), cell, opGroup);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (opGroup == null) continue;
                    if (throwable != null) {
                        try {
                            opGroup.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    opGroup.close();
                }
            }
        }

        @Override
        public void updateRowLevelIndexes() {
            for (SecondaryIndex index : SecondaryIndexManager.this.rowLevelIndexMap.values()) {
                ((PerRowSecondaryIndex)index).index(this.key.getKey(), null);
            }
        }
    }

    public static interface Updater {
        public void insert(Cell var1);

        public void update(Cell var1, Cell var2);

        public void remove(Cell var1);

        public void updateRowLevelIndexes();
    }
}

