/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.lifecycle.Helpers;
import org.apache.cassandra.db.lifecycle.SSTableIntervalTree;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Interval;

public class View {
    public final List<Memtable> liveMemtables;
    public final List<Memtable> flushingMemtables;
    public final Set<SSTableReader> compacting;
    public final Set<SSTableReader> sstables;
    public final Map<SSTableReader, SSTableReader> sstablesMap;
    public final SSTableIntervalTree intervalTree;

    View(List<Memtable> liveMemtables, List<Memtable> flushingMemtables, Map<SSTableReader, SSTableReader> sstables, Set<SSTableReader> compacting, SSTableIntervalTree intervalTree) {
        assert (liveMemtables != null);
        assert (flushingMemtables != null);
        assert (sstables != null);
        assert (compacting != null);
        assert (intervalTree != null);
        this.liveMemtables = liveMemtables;
        this.flushingMemtables = flushingMemtables;
        this.sstablesMap = sstables;
        this.sstables = this.sstablesMap.keySet();
        this.compacting = compacting;
        this.intervalTree = intervalTree;
    }

    public Memtable getCurrentMemtable() {
        return this.liveMemtables.get(this.liveMemtables.size() - 1);
    }

    public Iterable<Memtable> getAllMemtables() {
        return Iterables.concat(this.flushingMemtables, this.liveMemtables);
    }

    public Sets.SetView<SSTableReader> nonCompactingSStables() {
        return Sets.difference(this.sstables, this.compacting);
    }

    public Iterable<SSTableReader> getUncompacting(Iterable<SSTableReader> candidates) {
        return Iterables.filter(candidates, new Predicate<SSTableReader>(){

            @Override
            public boolean apply(SSTableReader sstable) {
                return !View.this.compacting.contains(sstable);
            }
        });
    }

    public String toString() {
        return String.format("View(pending_count=%d, sstables=%s, compacting=%s)", this.liveMemtables.size() + this.flushingMemtables.size() - 1, this.sstables, this.compacting);
    }

    public List<SSTableReader> sstablesInBounds(RowPosition left, RowPosition right) {
        assert (!AbstractBounds.strictlyWrapsAround(left, right));
        if (this.intervalTree.isEmpty()) {
            return Collections.emptyList();
        }
        RowPosition stopInTree = right.isMinimum() ? (RowPosition)this.intervalTree.max() : right;
        return this.intervalTree.search(Interval.create(left, stopInTree));
    }

    static Function<View, View> updateCompacting(final Set<SSTableReader> unmark, final Iterable<SSTableReader> mark) {
        if (unmark.isEmpty() && Iterables.isEmpty(mark)) {
            return Functions.identity();
        }
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                assert (Iterables.all(mark, Helpers.idIn(view.sstablesMap)));
                return new View(view.liveMemtables, view.flushingMemtables, view.sstablesMap, Helpers.replace(view.compacting, unmark, mark), view.intervalTree);
            }
        };
    }

    static Predicate<View> permitCompacting(final Iterable<SSTableReader> readers) {
        return new Predicate<View>(){

            @Override
            public boolean apply(View view) {
                for (SSTableReader reader : readers) {
                    if (!view.compacting.contains(reader) && view.sstablesMap.get(reader) == reader && !reader.isMarkedCompacted()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    static Function<View, View> updateLiveSet(final Set<SSTableReader> remove, final Iterable<SSTableReader> add) {
        if (remove.isEmpty() && Iterables.isEmpty(add)) {
            return Functions.identity();
        }
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                Map<SSTableReader, SSTableReader> sstableMap = Helpers.replace(view.sstablesMap, remove, add);
                return new View(view.liveMemtables, view.flushingMemtables, sstableMap, view.compacting, SSTableIntervalTree.build(sstableMap.keySet()));
            }
        };
    }

    static Function<View, View> switchMemtable(final Memtable newMemtable) {
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                ImmutableCollection newLive = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(view.liveMemtables)).add(newMemtable)).build();
                assert (newLive.size() == view.liveMemtables.size() + 1);
                return new View((List<Memtable>)((Object)newLive), view.flushingMemtables, view.sstablesMap, view.compacting, view.intervalTree);
            }
        };
    }

    static Function<View, View> markFlushing(final Memtable toFlush) {
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                List<Memtable> live = view.liveMemtables;
                List<Memtable> flushing = view.flushingMemtables;
                ImmutableList<Memtable> newLive = ImmutableList.copyOf(Iterables.filter(live, Predicates.not(Predicates.equalTo(toFlush))));
                ImmutableList<Memtable> newFlushing = ImmutableList.copyOf(Iterables.concat(Iterables.filter(flushing, View.lessThan(toFlush)), ImmutableList.of(toFlush), Iterables.filter(flushing, Predicates.not(View.lessThan(toFlush)))));
                assert (newLive.size() == live.size() - 1);
                assert (newFlushing.size() == flushing.size() + 1);
                return new View(newLive, newFlushing, view.sstablesMap, view.compacting, view.intervalTree);
            }
        };
    }

    static Function<View, View> replaceFlushed(final Memtable memtable, final SSTableReader flushed) {
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                ImmutableList<Memtable> flushingMemtables = ImmutableList.copyOf(Iterables.filter(view.flushingMemtables, Predicates.not(Predicates.equalTo(memtable))));
                assert (flushingMemtables.size() == view.flushingMemtables.size() - 1);
                if (flushed == null) {
                    return new View(view.liveMemtables, flushingMemtables, view.sstablesMap, view.compacting, view.intervalTree);
                }
                Map<SSTableReader, SSTableReader> sstableMap = Helpers.replace(view.sstablesMap, Helpers.emptySet(), Collections.singleton(flushed));
                return new View(view.liveMemtables, flushingMemtables, sstableMap, view.compacting, SSTableIntervalTree.build(sstableMap.keySet()));
            }
        };
    }

    private static <T extends Comparable<T>> Predicate<T> lessThan(final T lessThan) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t) {
                return t.compareTo((Comparable)lessThan) < 0;
            }
        };
    }
}

