/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.utils.NativeSSTableLoaderClient;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class BulkRecordWriter
extends org.apache.hadoop.mapreduce.RecordWriter<ByteBuffer, List<Mutation>>
implements RecordWriter<ByteBuffer, List<Mutation>> {
    public static final String OUTPUT_LOCATION = "mapreduce.output.bulkoutputformat.localdir";
    public static final String BUFFER_SIZE_IN_MB = "mapreduce.output.bulkoutputformat.buffersize";
    public static final String STREAM_THROTTLE_MBITS = "mapreduce.output.bulkoutputformat.streamthrottlembits";
    public static final String MAX_FAILED_HOSTS = "mapreduce.output.bulkoutputformat.maxfailedhosts";
    private final Logger logger = LoggerFactory.getLogger(BulkRecordWriter.class);
    protected final Configuration conf;
    protected final int maxFailures;
    protected final int bufferSize;
    protected Closeable writer;
    protected SSTableLoader loader;
    protected Progressable progress;
    protected TaskAttemptContext context;
    private File outputDir;
    private CFType cfType;
    private ColType colType;

    BulkRecordWriter(TaskAttemptContext context) {
        this(HadoopCompat.getConfiguration((JobContext)context));
        this.context = context;
    }

    BulkRecordWriter(Configuration conf, Progressable progress) {
        this(conf);
        this.progress = progress;
    }

    BulkRecordWriter(Configuration conf) {
        Config.setOutboundBindAny(true);
        this.conf = conf;
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(Integer.parseInt(conf.get(STREAM_THROTTLE_MBITS, "0")));
        this.maxFailures = Integer.parseInt(conf.get(MAX_FAILED_HOSTS, "0"));
        this.bufferSize = Integer.parseInt(conf.get(BUFFER_SIZE_IN_MB, "64"));
    }

    protected String getOutputLocation() throws IOException {
        String dir = this.conf.get(OUTPUT_LOCATION, System.getProperty("java.io.tmpdir"));
        if (dir == null) {
            throw new IOException("Output directory not defined, if hadoop is not setting java.io.tmpdir then define mapreduce.output.bulkoutputformat.localdir");
        }
        return dir;
    }

    private void setTypes(Mutation mutation) {
        if (this.cfType == null) {
            this.cfType = mutation.getColumn_or_supercolumn().isSetSuper_column() || mutation.getColumn_or_supercolumn().isSetCounter_super_column() ? CFType.SUPER : CFType.NORMAL;
            this.colType = mutation.getColumn_or_supercolumn().isSetCounter_column() || mutation.getColumn_or_supercolumn().isSetCounter_super_column() ? ColType.COUNTER : ColType.NORMAL;
        }
    }

    private void prepareWriter() throws IOException {
        if (this.outputDir == null) {
            String keyspace = ConfigHelper.getOutputKeyspace(this.conf);
            this.outputDir = new File(this.getOutputLocation() + File.separator + keyspace + File.separator + ConfigHelper.getOutputColumnFamily(this.conf));
            this.outputDir.mkdirs();
        }
        if (this.writer == null) {
            BytesType subcomparator = null;
            if (this.cfType == CFType.SUPER) {
                subcomparator = BytesType.instance;
            }
            this.writer = new SSTableSimpleUnsortedWriter(this.outputDir, ConfigHelper.getOutputPartitioner(this.conf), ConfigHelper.getOutputKeyspace(this.conf), ConfigHelper.getOutputColumnFamily(this.conf), BytesType.instance, subcomparator, Integer.parseInt(this.conf.get(BUFFER_SIZE_IN_MB, "64")), ConfigHelper.getOutputCompressionParamaters(this.conf));
            this.loader = new SSTableLoader(this.outputDir, new ExternalClient(this.conf), new NullOutputHandler());
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.close();
    }

    @Deprecated
    public void close(Reporter reporter) throws IOException {
        this.close();
    }

    private void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            StreamResultFuture future = this.loader.stream();
            while (true) {
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException | TimeoutException te) {
                    if (null != this.progress) {
                        this.progress.progress();
                    }
                    if (null == this.context) continue;
                    HadoopCompat.progress(this.context);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                break;
            }
            if (this.loader.getFailedHosts().size() > 0) {
                if (this.loader.getFailedHosts().size() > this.maxFailures) {
                    throw new IOException("Too many hosts failed: " + this.loader.getFailedHosts());
                }
                this.logger.warn("Some hosts failed: {}", (Object)this.loader.getFailedHosts());
            }
        }
    }

    public void write(ByteBuffer keybuff, List<Mutation> value) throws IOException {
        this.setTypes(value.get(0));
        this.prepareWriter();
        SSTableSimpleUnsortedWriter ssWriter = (SSTableSimpleUnsortedWriter)this.writer;
        ssWriter.newRow(keybuff);
        for (Mutation mut : value) {
            if (this.cfType == CFType.SUPER) {
                ssWriter.newSuperColumn(mut.getColumn_or_supercolumn().getSuper_column().name);
                if (this.colType == ColType.COUNTER) {
                    for (CounterColumn column : mut.getColumn_or_supercolumn().getCounter_super_column().columns) {
                        ssWriter.addCounterColumn(column.name, column.value);
                    }
                } else {
                    for (CounterColumn column : mut.getColumn_or_supercolumn().getSuper_column().columns) {
                        if (column.ttl == 0) {
                            ssWriter.addColumn(column.name, column.value, column.timestamp);
                            continue;
                        }
                        ssWriter.addExpiringColumn(column.name, column.value, column.timestamp, column.ttl, System.currentTimeMillis() + (long)column.ttl * 1000L);
                    }
                }
            } else if (this.colType == ColType.COUNTER) {
                ssWriter.addCounterColumn(mut.getColumn_or_supercolumn().counter_column.name, mut.getColumn_or_supercolumn().counter_column.value);
            } else if (mut.getColumn_or_supercolumn().column.ttl == 0) {
                ssWriter.addColumn(mut.getColumn_or_supercolumn().column.name, mut.getColumn_or_supercolumn().column.value, mut.getColumn_or_supercolumn().column.timestamp);
            } else {
                ssWriter.addExpiringColumn(mut.getColumn_or_supercolumn().column.name, mut.getColumn_or_supercolumn().column.value, mut.getColumn_or_supercolumn().column.timestamp, mut.getColumn_or_supercolumn().column.ttl, System.currentTimeMillis() + (long)mut.getColumn_or_supercolumn().column.ttl * 1000L);
            }
            if (null != this.progress) {
                this.progress.progress();
            }
            if (null == this.context) continue;
            HadoopCompat.progress(this.context);
        }
    }

    public static class NullOutputHandler
    implements OutputHandler {
        @Override
        public void output(String msg) {
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void warn(String msg) {
        }

        @Override
        public void warn(String msg, Throwable th) {
        }
    }

    public static class ExternalClient
    extends NativeSSTableLoaderClient {
        public ExternalClient(Configuration conf) {
            super(ExternalClient.resolveHostAddresses(conf), CqlConfigHelper.getOutputNativePort(conf), ConfigHelper.getOutputKeyspaceUserName(conf), ConfigHelper.getOutputKeyspacePassword(conf), CqlConfigHelper.getSSLOptions(conf).orNull());
        }

        private static Collection<InetAddress> resolveHostAddresses(Configuration conf) {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            for (String host : ConfigHelper.getOutputInitialAddress(conf).split(",")) {
                try {
                    addresses.add(InetAddress.getByName(host));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            return addresses;
        }
    }

    private static enum ColType {
        NORMAL,
        COUNTER;

    }

    private static enum CFType {
        NORMAL,
        SUPER;

    }
}

