/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.hadoop.ColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ColumnFamilyRecordReader
extends RecordReader<ByteBuffer, SortedMap<ByteBuffer, Column>>
implements org.apache.hadoop.mapred.RecordReader<ByteBuffer, SortedMap<ByteBuffer, Column>> {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyRecordReader.class);
    public static final int CASSANDRA_HADOOP_MAX_KEY_SIZE_DEFAULT = 8192;
    private ColumnFamilySplit split;
    private RowIterator iter;
    private Pair<ByteBuffer, SortedMap<ByteBuffer, Column>> currentRow;
    private SlicePredicate predicate;
    private boolean isEmptyPredicate;
    private int totalRowCount;
    private int batchSize;
    private String keyspace;
    private String cfName;
    private Cassandra.Client client;
    private ConsistencyLevel consistencyLevel;
    private int keyBufferSize = 8192;
    private List<IndexExpression> filter;

    public ColumnFamilyRecordReader() {
        this(8192);
    }

    public ColumnFamilyRecordReader(int keyBufferSize) {
        this.keyBufferSize = keyBufferSize;
    }

    public void close() {
        TTransport transport;
        if (this.client != null && (transport = this.client.getOutputProtocol().getTransport()).isOpen()) {
            transport.close();
        }
    }

    public ByteBuffer getCurrentKey() {
        return (ByteBuffer)this.currentRow.left;
    }

    public SortedMap<ByteBuffer, Column> getCurrentValue() {
        return (SortedMap)this.currentRow.right;
    }

    public float getProgress() {
        if (!this.iter.hasNext()) {
            return 1.0f;
        }
        float progress = (float)this.iter.rowsRead() / (float)this.totalRowCount;
        return progress > 1.0f ? 1.0f : progress;
    }

    static boolean isEmptyPredicate(SlicePredicate predicate) {
        if (predicate == null) {
            return true;
        }
        if (predicate.isSetColumn_names() && predicate.getSlice_range() == null) {
            return false;
        }
        if (predicate.getSlice_range() == null) {
            return true;
        }
        byte[] start = predicate.getSlice_range().getStart();
        if (start != null && start.length > 0) {
            return false;
        }
        byte[] finish = predicate.getSlice_range().getFinish();
        return finish == null || finish.length <= 0;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.split = (ColumnFamilySplit)split;
        Configuration conf = HadoopCompat.getConfiguration((JobContext)context);
        KeyRange jobRange = ConfigHelper.getInputKeyRange(conf);
        this.filter = jobRange == null ? null : jobRange.row_filter;
        this.predicate = ConfigHelper.getInputSlicePredicate(conf);
        boolean widerows = ConfigHelper.getInputIsWide(conf);
        this.isEmptyPredicate = ColumnFamilyRecordReader.isEmptyPredicate(this.predicate);
        this.totalRowCount = this.split.getLength() < Long.MAX_VALUE ? (int)this.split.getLength() : ConfigHelper.getInputSplitSize(conf);
        this.batchSize = ConfigHelper.getRangeBatchSize(conf);
        this.cfName = ConfigHelper.getInputColumnFamily(conf);
        this.consistencyLevel = ConsistencyLevel.valueOf((String)ConfigHelper.getReadConsistencyLevel(conf));
        this.keyspace = ConfigHelper.getInputKeyspace(conf);
        if (this.batchSize < 2) {
            throw new IllegalArgumentException("Minimum batchSize is 2.  Suggested batchSize is 100 or more");
        }
        try {
            if (this.client != null) {
                return;
            }
            String location = this.getLocation();
            int port = ConfigHelper.getInputRpcPort(conf);
            this.client = ColumnFamilyInputFormat.createAuthenticatedClient(location, port, conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.iter = widerows ? new WideRowIterator() : new StaticRowIterator();
        logger.trace("created {}", (Object)this.iter);
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.iter.hasNext()) {
            logger.trace("Finished scanning {} rows (estimate was: {})", (Object)this.iter.rowsRead(), (Object)this.totalRowCount);
            return false;
        }
        this.currentRow = (Pair)this.iter.next();
        return true;
    }

    private String getLocation() {
        Collection<InetAddress> localAddresses = FBUtilities.getAllLocalAddresses();
        for (InetAddress address : localAddresses) {
            for (String location : this.split.getLocations()) {
                InetAddress locationAddress = null;
                try {
                    locationAddress = InetAddress.getByName(location);
                }
                catch (UnknownHostException e) {
                    throw new AssertionError((Object)e);
                }
                if (!address.equals(locationAddress)) continue;
                return location;
            }
        }
        return this.split.getLocations()[0];
    }

    public boolean next(ByteBuffer key, SortedMap<ByteBuffer, Column> value) throws IOException {
        if (this.nextKeyValue()) {
            key.clear();
            key.put(this.getCurrentKey().duplicate());
            key.flip();
            value.clear();
            value.putAll((Map<ByteBuffer, Column>)this.getCurrentValue());
            return true;
        }
        return false;
    }

    public ByteBuffer createKey() {
        return ByteBuffer.wrap(new byte[this.keyBufferSize]);
    }

    public SortedMap<ByteBuffer, Column> createValue() {
        return new TreeMap<ByteBuffer, Column>();
    }

    public long getPos() throws IOException {
        return this.iter.rowsRead();
    }

    public static final class Column {
        public final ByteBuffer name;
        public final ByteBuffer value;
        public final long timestamp;

        private Column(ByteBuffer name, ByteBuffer value, long timestamp) {
            this.name = name;
            this.value = value;
            this.timestamp = timestamp;
        }

        static Column fromRegularColumn(org.apache.cassandra.thrift.Column input) {
            return new Column(input.name, input.value, input.timestamp);
        }

        static Column fromCounterColumn(CounterColumn input) {
            return new Column(input.name, ByteBufferUtil.bytes(input.value), 0L);
        }
    }

    private class WideRowIterator
    extends RowIterator {
        private PeekingIterator<Pair<ByteBuffer, SortedMap<ByteBuffer, Column>>> wideColumns;
        private ByteBuffer lastColumn;
        private ByteBuffer lastCountedKey;

        private WideRowIterator() {
            this.lastColumn = ByteBufferUtil.EMPTY_BYTE_BUFFER;
            this.lastCountedKey = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }

        private void maybeInit() {
            KeyRange keyRange;
            if (this.wideColumns != null && this.wideColumns.hasNext()) {
                return;
            }
            if (this.totalRead == 0) {
                String startToken = ColumnFamilyRecordReader.this.split.getStartToken();
                keyRange = new KeyRange(ColumnFamilyRecordReader.this.batchSize).setStart_token(startToken).setEnd_token(ColumnFamilyRecordReader.this.split.getEndToken()).setRow_filter(ColumnFamilyRecordReader.this.filter);
            } else {
                KeySlice lastRow = (KeySlice)Iterables.getLast(this.rows);
                logger.trace("Starting with last-seen row {}", (Object)lastRow.key);
                keyRange = new KeyRange(ColumnFamilyRecordReader.this.batchSize).setStart_key(lastRow.key).setEnd_token(ColumnFamilyRecordReader.this.split.getEndToken()).setRow_filter(ColumnFamilyRecordReader.this.filter);
            }
            try {
                this.rows = ColumnFamilyRecordReader.this.client.get_paged_slice(ColumnFamilyRecordReader.this.cfName, keyRange, this.lastColumn, ColumnFamilyRecordReader.this.consistencyLevel);
                int n = 0;
                for (KeySlice row : this.rows) {
                    n += row.columns.size();
                }
                logger.trace("read {} columns in {} rows for {} starting with {}", n, this.rows.size(), keyRange, this.lastColumn);
                this.wideColumns = Iterators.peekingIterator(new WideColumnIterator(this.rows));
                if (this.wideColumns.hasNext() && ((ByteBuffer)((SortedMap)this.wideColumns.peek().right).keySet().iterator().next()).equals(this.lastColumn)) {
                    this.wideColumns.next();
                }
                if (!this.wideColumns.hasNext()) {
                    this.rows = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected Pair<ByteBuffer, SortedMap<ByteBuffer, Column>> computeNext() {
            this.maybeInit();
            if (this.rows == null) {
                return (Pair)this.endOfData();
            }
            Pair<ByteBuffer, SortedMap<ByteBuffer, Column>> next = this.wideColumns.next();
            this.lastColumn = ((ByteBuffer)((SortedMap)next.right).keySet().iterator().next()).duplicate();
            this.maybeIncreaseRowCounter(next);
            return next;
        }

        private void maybeIncreaseRowCounter(Pair<ByteBuffer, SortedMap<ByteBuffer, Column>> next) {
            ByteBuffer currentKey = (ByteBuffer)next.left;
            if (!currentKey.equals(this.lastCountedKey)) {
                ++this.totalRead;
                this.lastCountedKey = currentKey;
            }
        }

        private class WideColumnIterator
        extends AbstractIterator<Pair<ByteBuffer, SortedMap<ByteBuffer, Column>>> {
            private final Iterator<KeySlice> rows;
            private Iterator<ColumnOrSuperColumn> columns;
            public KeySlice currentRow;

            public WideColumnIterator(List<KeySlice> rows) {
                this.rows = rows.iterator();
                if (this.rows.hasNext()) {
                    this.nextRow();
                } else {
                    this.columns = Iterators.emptyIterator();
                }
            }

            private void nextRow() {
                this.currentRow = this.rows.next();
                this.columns = this.currentRow.columns.iterator();
            }

            @Override
            protected Pair<ByteBuffer, SortedMap<ByteBuffer, Column>> computeNext() {
                AbstractType comp;
                AbstractType abstractType = comp = WideRowIterator.this.isSuper ? CompositeType.getInstance(WideRowIterator.this.comparator, WideRowIterator.this.subComparator) : WideRowIterator.this.comparator;
                while (true) {
                    if (this.columns.hasNext()) {
                        NavigableMap<Comparable<ByteBuffer>, Object> map;
                        ColumnOrSuperColumn cosc = this.columns.next();
                        List<Pair<ByteBuffer, Column>> columns = WideRowIterator.this.unthriftify(cosc);
                        if (columns.size() == 1) {
                            map = ImmutableSortedMap.of((Comparable)columns.get((int)0).left, columns.get((int)0).right);
                        } else {
                            assert (WideRowIterator.this.isSuper);
                            map = new TreeMap(comp);
                            for (Pair<ByteBuffer, Column> column : columns) {
                                map.put((Comparable<ByteBuffer>)column.left, column.right);
                            }
                        }
                        return Pair.create(this.currentRow.key, map);
                    }
                    if (!this.rows.hasNext()) {
                        return (Pair)this.endOfData();
                    }
                    this.nextRow();
                }
            }
        }
    }

    private class StaticRowIterator
    extends RowIterator {
        protected int i;

        private StaticRowIterator() {
            this.i = 0;
        }

        private void maybeInit() {
            String startToken;
            if (this.rows != null && this.i < this.rows.size()) {
                return;
            }
            if (this.totalRead == 0) {
                startToken = ColumnFamilyRecordReader.this.split.getStartToken();
            } else {
                startToken = this.partitioner.getTokenFactory().toString(this.partitioner.getToken(((KeySlice)Iterables.getLast(this.rows)).key));
                if (startToken.equals(ColumnFamilyRecordReader.this.split.getEndToken())) {
                    this.rows = null;
                    return;
                }
            }
            KeyRange keyRange = new KeyRange(ColumnFamilyRecordReader.this.batchSize).setStart_token(startToken).setEnd_token(ColumnFamilyRecordReader.this.split.getEndToken()).setRow_filter(ColumnFamilyRecordReader.this.filter);
            try {
                this.rows = ColumnFamilyRecordReader.this.client.get_range_slices(new ColumnParent(ColumnFamilyRecordReader.this.cfName), ColumnFamilyRecordReader.this.predicate, keyRange, ColumnFamilyRecordReader.this.consistencyLevel);
                if (this.rows.isEmpty()) {
                    this.rows = null;
                    return;
                }
                if (ColumnFamilyRecordReader.this.isEmptyPredicate) {
                    KeySlice ks;
                    Iterator it = this.rows.iterator();
                    do {
                        if ((ks = (KeySlice)it.next()).getColumnsSize() != 0) continue;
                        it.remove();
                    } while (it.hasNext());
                    if (this.rows.isEmpty()) {
                        this.rows.add(ks);
                        this.maybeInit();
                        return;
                    }
                }
                this.i = 0;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected Pair<ByteBuffer, SortedMap<ByteBuffer, Column>> computeNext() {
            this.maybeInit();
            if (this.rows == null) {
                return (Pair)this.endOfData();
            }
            ++this.totalRead;
            KeySlice ks = (KeySlice)this.rows.get(this.i++);
            AbstractType comp = this.isSuper ? CompositeType.getInstance(this.comparator, this.subComparator) : this.comparator;
            TreeMap map = new TreeMap(comp);
            for (ColumnOrSuperColumn cosc : ks.columns) {
                List<Pair<ByteBuffer, Column>> columns = this.unthriftify(cosc);
                for (Pair<ByteBuffer, Column> column : columns) {
                    map.put((ByteBuffer)column.left, column.right);
                }
            }
            return Pair.create(ks.key, map);
        }
    }

    private abstract class RowIterator
    extends AbstractIterator<Pair<ByteBuffer, SortedMap<ByteBuffer, Column>>> {
        protected List<KeySlice> rows;
        protected int totalRead = 0;
        protected final boolean isSuper;
        protected final AbstractType<?> comparator;
        protected final AbstractType<?> subComparator;
        protected final IPartitioner partitioner;

        private RowIterator() {
            CfDef cfDef = new CfDef();
            try {
                this.partitioner = FBUtilities.newPartitioner(ColumnFamilyRecordReader.this.client.describe_partitioner());
                String query = String.format("SELECT comparator, subcomparator, type FROM %s.%s WHERE keyspace_name = '%s' AND columnfamily_name = '%s'", "system", "schema_columnfamilies", ColumnFamilyRecordReader.this.keyspace, ColumnFamilyRecordReader.this.cfName);
                CqlResult result = ColumnFamilyRecordReader.this.client.execute_cql3_query(ByteBufferUtil.bytes(query), Compression.NONE, ConsistencyLevel.ONE);
                Iterator iteraRow = result.rows.iterator();
                if (iteraRow.hasNext()) {
                    ByteBuffer type;
                    CqlRow cqlRow = (CqlRow)iteraRow.next();
                    cfDef.comparator_type = ByteBufferUtil.string(((org.apache.cassandra.thrift.Column)cqlRow.columns.get((int)0)).value);
                    ByteBuffer subComparator = ((org.apache.cassandra.thrift.Column)cqlRow.columns.get((int)1)).value;
                    if (subComparator != null) {
                        cfDef.subcomparator_type = ByteBufferUtil.string(subComparator);
                    }
                    if ((type = ((org.apache.cassandra.thrift.Column)cqlRow.columns.get((int)2)).value) != null) {
                        cfDef.column_type = ByteBufferUtil.string(type);
                    }
                }
                this.comparator = TypeParser.parse(cfDef.comparator_type);
                this.subComparator = cfDef.subcomparator_type == null ? null : TypeParser.parse(cfDef.subcomparator_type);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("unable to load sub/comparator", e);
            }
            catch (TException e) {
                throw new RuntimeException("error communicating via Thrift", e);
            }
            catch (Exception e) {
                throw new RuntimeException("unable to load keyspace " + ColumnFamilyRecordReader.this.keyspace, e);
            }
            this.isSuper = "Super".equalsIgnoreCase(cfDef.column_type);
        }

        public int rowsRead() {
            return this.totalRead;
        }

        protected List<Pair<ByteBuffer, Column>> unthriftify(ColumnOrSuperColumn cosc) {
            if (cosc.counter_column != null) {
                return Collections.singletonList(this.unthriftifyCounter(cosc.counter_column));
            }
            if (cosc.counter_super_column != null) {
                return this.unthriftifySuperCounter(cosc.counter_super_column);
            }
            if (cosc.super_column != null) {
                return this.unthriftifySuper(cosc.super_column);
            }
            assert (cosc.column != null);
            return Collections.singletonList(this.unthriftifySimple(cosc.column));
        }

        private List<Pair<ByteBuffer, Column>> unthriftifySuper(SuperColumn super_column) {
            ArrayList<Pair<ByteBuffer, Column>> columns = new ArrayList<Pair<ByteBuffer, Column>>(super_column.columns.size());
            for (org.apache.cassandra.thrift.Column column : super_column.columns) {
                Pair<ByteBuffer, Column> c = this.unthriftifySimple(column);
                columns.add(Pair.create(CompositeType.build(super_column.name, (ByteBuffer)c.left), c.right));
            }
            return columns;
        }

        protected Pair<ByteBuffer, Column> unthriftifySimple(org.apache.cassandra.thrift.Column column) {
            return Pair.create(column.name, Column.fromRegularColumn(column));
        }

        private Pair<ByteBuffer, Column> unthriftifyCounter(CounterColumn column) {
            return Pair.create(column.name, Column.fromCounterColumn(column));
        }

        private List<Pair<ByteBuffer, Column>> unthriftifySuperCounter(CounterSuperColumn super_column) {
            ArrayList<Pair<ByteBuffer, Column>> columns = new ArrayList<Pair<ByteBuffer, Column>>(super_column.columns.size());
            for (CounterColumn column : super_column.columns) {
                Pair<ByteBuffer, Column> c = this.unthriftifyCounter(column);
                columns.add(Pair.create(CompositeType.build(super_column.name, (ByteBuffer)c.left), c.right));
            }
            return columns;
        }
    }
}

