/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import com.google.common.primitives.Ints;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.Adler32;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.FBUtilities;

public class CompressedRandomAccessReader
extends RandomAccessReader {
    private final TreeMap<Long, MappedByteBuffer> chunkSegments;
    private final CompressionMetadata metadata;
    private ByteBuffer compressed;
    private final Adler32 checksum;
    private ByteBuffer checksumBytes;

    public static CompressedRandomAccessReader open(ChannelProxy channel, CompressionMetadata metadata) {
        try {
            return new CompressedRandomAccessReader(channel, metadata, null);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompressedRandomAccessReader open(ICompressedFile file) {
        try {
            return new CompressedRandomAccessReader(file.channel(), file.getMetadata(), file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected CompressedRandomAccessReader(ChannelProxy channel, CompressionMetadata metadata, ICompressedFile file) throws FileNotFoundException {
        super(channel, metadata.chunkLength(), metadata.compressedFileLength, metadata.compressor().preferredBufferType(), file instanceof PoolingSegmentedFile ? (PoolingSegmentedFile)((Object)file) : null);
        this.metadata = metadata;
        this.checksum = new Adler32();
        TreeMap<Long, MappedByteBuffer> treeMap = this.chunkSegments = file == null ? null : file.chunkSegments();
        if (this.chunkSegments == null) {
            this.compressed = super.allocateBuffer(metadata.compressor().initialCompressedBufferLength(metadata.chunkLength()), metadata.compressor().preferredBufferType());
            this.checksumBytes = ByteBuffer.wrap(new byte[4]);
        }
    }

    @Override
    protected ByteBuffer allocateBuffer(int bufferSize, BufferType bufferType) {
        assert (Integer.bitCount(bufferSize) == 1);
        return bufferType.allocate(bufferSize);
    }

    @Override
    public void deallocate() {
        super.deallocate();
        if (this.compressed != null) {
            FileUtils.clean(this.compressed);
        }
        this.compressed = null;
    }

    private void reBufferStandard() {
        try {
            long position = this.current();
            assert (position < this.metadata.dataLength);
            CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
            if (this.compressed.capacity() < chunk.length) {
                this.compressed = this.allocateBuffer(chunk.length, this.metadata.compressor().preferredBufferType());
            } else {
                this.compressed.clear();
            }
            this.compressed.limit(chunk.length);
            if (this.channel.read(this.compressed, chunk.offset) != chunk.length) {
                throw new CorruptBlockException(this.getPath(), chunk);
            }
            this.compressed.flip();
            this.buffer.clear();
            try {
                this.metadata.compressor().uncompress(this.compressed, this.buffer);
            }
            catch (IOException e) {
                throw new CorruptBlockException(this.getPath(), chunk);
            }
            finally {
                this.buffer.flip();
            }
            if (this.metadata.parameters.getCrcCheckChance() > ThreadLocalRandom.current().nextDouble()) {
                this.compressed.rewind();
                FBUtilities.directCheckSum(this.checksum, this.compressed);
                if (this.checksum(chunk) != (int)this.checksum.getValue()) {
                    throw new CorruptBlockException(this.getPath(), chunk);
                }
                this.checksum.reset();
            }
            this.bufferOffset = position & (long)(~(this.buffer.capacity() - 1));
            this.buffer.position((int)(position - this.bufferOffset));
            if (this.bufferOffset + (long)this.buffer.limit() > this.length()) {
                this.buffer.limit((int)(this.length() - this.bufferOffset));
            }
        }
        catch (CorruptBlockException e) {
            throw new CorruptSSTableException((Exception)e, this.getPath());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    private void reBufferMmap() {
        try {
            long position = this.current();
            assert (position < this.metadata.dataLength);
            CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
            Map.Entry<Long, MappedByteBuffer> entry = this.chunkSegments.floorEntry(chunk.offset);
            long segmentOffset = entry.getKey();
            int chunkOffset = Ints.checkedCast(chunk.offset - segmentOffset);
            ByteBuffer compressedChunk = entry.getValue().duplicate();
            compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
            this.buffer.clear();
            try {
                this.metadata.compressor().uncompress(compressedChunk, this.buffer);
            }
            catch (IOException e) {
                throw new CorruptBlockException(this.getPath(), chunk);
            }
            finally {
                this.buffer.flip();
            }
            if (this.metadata.parameters.getCrcCheckChance() > ThreadLocalRandom.current().nextDouble()) {
                compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
                FBUtilities.directCheckSum(this.checksum, compressedChunk);
                compressedChunk.limit(compressedChunk.capacity());
                if (compressedChunk.getInt() != (int)this.checksum.getValue()) {
                    throw new CorruptBlockException(this.getPath(), chunk);
                }
                this.checksum.reset();
            }
            this.bufferOffset = position & (long)(~(this.buffer.capacity() - 1));
            this.buffer.position((int)(position - this.bufferOffset));
            if (this.bufferOffset + (long)this.buffer.limit() > this.length()) {
                this.buffer.limit((int)(this.length() - this.bufferOffset));
            }
        }
        catch (CorruptBlockException e) {
            throw new CorruptSSTableException((Exception)e, this.getPath());
        }
    }

    @Override
    protected void reBuffer() {
        if (this.chunkSegments != null) {
            this.reBufferMmap();
        } else {
            this.reBufferStandard();
        }
    }

    private int checksum(CompressionMetadata.Chunk chunk) throws IOException {
        long position = chunk.offset + (long)chunk.length;
        this.checksumBytes.clear();
        if (this.channel.read(this.checksumBytes, position) != this.checksumBytes.capacity()) {
            throw new CorruptBlockException(this.getPath(), chunk);
        }
        return this.checksumBytes.getInt(0);
    }

    @Override
    public int getTotalBufferSize() {
        return super.getTotalBufferSize() + (this.chunkSegments != null ? 0 : this.compressed.capacity());
    }

    @Override
    public long length() {
        return this.metadata.dataLength;
    }

    @Override
    public String toString() {
        return String.format("%s - chunk length %d, data length %d.", this.getPath(), this.metadata.chunkLength(), this.metadata.dataLength);
    }
}

