/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayDeque;
import java.util.StringTokenizer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.LegacyMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataSerializer;
import org.apache.cassandra.utils.Pair;

public class Descriptor {
    public final File directory;
    public final Version version;
    public final String ksname;
    public final String cfname;
    public final int generation;
    public final Type type;
    public final SSTableFormat.Type formatType;
    private final int hashCode;

    public Descriptor(File directory, String ksname, String cfname, int generation, Type temp) {
        this(DatabaseDescriptor.getSSTableFormat().info.getLatestVersion(), directory, ksname, cfname, generation, temp, DatabaseDescriptor.getSSTableFormat());
    }

    public Descriptor(File directory, String ksname, String cfname, int generation, Type temp, SSTableFormat.Type formatType) {
        this(formatType.info.getLatestVersion(), directory, ksname, cfname, generation, temp, formatType);
    }

    public Descriptor(String version, File directory, String ksname, String cfname, int generation, Type temp, SSTableFormat.Type formatType) {
        this(formatType.info.getVersion(version), directory, ksname, cfname, generation, temp, formatType);
    }

    public Descriptor(Version version, File directory, String ksname, String cfname, int generation, Type temp, SSTableFormat.Type formatType) {
        assert (version != null && directory != null && ksname != null && cfname != null && formatType.info.getLatestVersion().getClass().equals(version.getClass()));
        this.version = version;
        this.directory = directory;
        this.ksname = ksname;
        this.cfname = cfname;
        this.generation = generation;
        this.type = temp;
        this.formatType = formatType;
        this.hashCode = Objects.hashCode(new Object[]{version, directory, generation, ksname, cfname, temp, formatType});
    }

    public Descriptor withGeneration(int newGeneration) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, newGeneration, this.type, this.formatType);
    }

    public Descriptor withFormatType(SSTableFormat.Type newType) {
        return new Descriptor(newType.info.getLatestVersion(), this.directory, this.ksname, this.cfname, this.generation, this.type, newType);
    }

    public String filenameFor(Component component) {
        return this.filenameFor(component.name());
    }

    public String baseFilename() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.directory).append(File.separatorChar);
        this.appendFileName(buff);
        return buff.toString();
    }

    private void appendFileName(StringBuilder buff) {
        if (!this.version.hasNewFileName()) {
            buff.append(this.ksname).append('-');
            buff.append(this.cfname).append('-');
        }
        if (this.type.isTemporary) {
            buff.append(this.type.marker).append('-');
        }
        buff.append(this.version).append('-');
        buff.append(this.generation);
        if (this.formatType != SSTableFormat.Type.LEGACY) {
            buff.append('-').append(this.formatType.name);
        }
    }

    public String relativeFilenameFor(Component component) {
        StringBuilder buff = new StringBuilder();
        this.appendFileName(buff);
        buff.append('-').append(component.name());
        return buff.toString();
    }

    public SSTableFormat getFormat() {
        return this.formatType.info;
    }

    public String filenameFor(String suffix) {
        return this.baseFilename() + '-' + suffix;
    }

    public static Descriptor fromFilename(String filename) {
        File file = new File(filename);
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName(), (boolean)false).left;
    }

    public static Descriptor fromFilename(String filename, SSTableFormat.Type formatType) {
        return Descriptor.fromFilename(filename).withFormatType(formatType);
    }

    public static Descriptor fromFilename(String filename, boolean skipComponent) {
        File file = new File(filename);
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName(), (boolean)skipComponent).left;
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name) {
        return Descriptor.fromFilename(directory, name, false);
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name, boolean skipComponent) {
        String ksname;
        String cfname;
        File parentDirectory = directory != null ? directory : new File(".");
        StringTokenizer st = new StringTokenizer(name, String.valueOf('-'));
        ArrayDeque<String> tokenStack = new ArrayDeque<String>();
        while (st.hasMoreTokens()) {
            tokenStack.push(st.nextToken());
        }
        String component = skipComponent ? null : (String)tokenStack.pop();
        String nexttok = (String)tokenStack.pop();
        SSTableFormat.Type fmt = SSTableFormat.Type.LEGACY;
        if (!CharMatcher.DIGIT.matchesAllOf(nexttok)) {
            fmt = SSTableFormat.Type.validate(nexttok);
            nexttok = (String)tokenStack.pop();
        }
        int generation = Integer.parseInt(nexttok);
        nexttok = (String)tokenStack.pop();
        Version version = fmt.info.getVersion(nexttok);
        if (!Version.validate(nexttok)) {
            throw new UnsupportedOperationException("SSTable " + name + " is too old to open.  Upgrade to 2.0 first, and run upgradesstables");
        }
        Type type = Type.FINAL;
        nexttok = (String)tokenStack.peek();
        if (Type.TEMP.marker.equals(nexttok)) {
            type = Type.TEMP;
            tokenStack.pop();
        } else if (Type.TEMPLINK.marker.equals(nexttok)) {
            type = Type.TEMPLINK;
            tokenStack.pop();
        }
        if (version.hasNewFileName()) {
            File cfDirectory = parentDirectory;
            String indexName = "";
            if (cfDirectory.getName().startsWith(".")) {
                indexName = cfDirectory.getName();
                cfDirectory = cfDirectory.getParentFile();
            }
            if (cfDirectory.getName().equals("backups")) {
                cfDirectory = cfDirectory.getParentFile();
            } else if (cfDirectory.getParentFile().getName().equals("snapshots")) {
                cfDirectory = cfDirectory.getParentFile().getParentFile();
            }
            cfname = cfDirectory.getName().split("-")[0] + indexName;
            ksname = cfDirectory.getParentFile().getName();
        } else {
            cfname = (String)tokenStack.pop();
            ksname = (String)tokenStack.pop();
        }
        assert (tokenStack.isEmpty()) : "Invalid file name " + name + " in " + directory;
        return Pair.create(new Descriptor(version, parentDirectory, ksname, cfname, generation, type, fmt), component);
    }

    public Descriptor asType(Type type) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, this.generation, type, this.formatType);
    }

    public IMetadataSerializer getMetadataSerializer() {
        if (this.version.hasNewStatsFile()) {
            return new MetadataSerializer();
        }
        return new LegacyMetadataSerializer();
    }

    public boolean isCompatible() {
        return this.version.isCompatible();
    }

    public String toString() {
        return this.baseFilename();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return that.directory.equals(this.directory) && that.generation == this.generation && that.ksname.equals(this.ksname) && that.cfname.equals(this.cfname) && that.formatType == this.formatType && that.type == this.type;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static enum Type {
        TEMP("tmp", true),
        TEMPLINK("tmplink", true),
        FINAL(null, false);

        public final boolean isTemporary;
        public final String marker;

        private Type(String marker, boolean isTemporary) {
            this.isTemporary = isTemporary;
            this.marker = marker;
        }
    }
}

