/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.memory.HeapAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTable {
    static final Logger logger = LoggerFactory.getLogger(SSTable.class);
    public static final int TOMBSTONE_HISTOGRAM_BIN_SIZE = 100;
    public final Descriptor descriptor;
    protected final Set<Component> components;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    public final boolean compression;
    public DecoratedKey first;
    public DecoratedKey last;

    protected SSTable(Descriptor descriptor, CFMetaData metadata, IPartitioner partitioner) {
        this(descriptor, new HashSet<Component>(), metadata, partitioner);
    }

    protected SSTable(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner) {
        assert (descriptor != null);
        assert (components != null);
        assert (partitioner != null);
        this.descriptor = descriptor;
        HashSet<Component> dataComponents = new HashSet<Component>(components);
        this.compression = dataComponents.contains(Component.COMPRESSION_INFO);
        this.components = new CopyOnWriteArraySet<Component>(dataComponents);
        this.metadata = metadata;
        this.partitioner = partitioner;
    }

    public static boolean delete(Descriptor desc, Set<Component> components) {
        if (components.contains(Component.DATA)) {
            FileUtils.deleteWithConfirm(desc.filenameFor(Component.DATA));
        }
        for (Component component : components) {
            if (component.equals(Component.DATA) || component.equals(Component.SUMMARY)) continue;
            FileUtils.deleteWithConfirm(desc.filenameFor(component));
        }
        FileUtils.delete(desc.filenameFor(Component.SUMMARY));
        logger.trace("Deleted {}", (Object)desc);
        return true;
    }

    public static DecoratedKey getMinimalKey(DecoratedKey key) {
        return key.getKey().position() > 0 || key.getKey().hasRemaining() || !key.getKey().hasArray() ? new BufferDecoratedKey(key.getToken(), HeapAllocator.instance.clone(key.getKey())) : key;
    }

    public String getFilename() {
        return this.descriptor.filenameFor(Component.DATA);
    }

    public String getIndexFilename() {
        return this.descriptor.filenameFor(Component.PRIMARY_INDEX);
    }

    public String getColumnFamilyName() {
        return this.descriptor.cfname;
    }

    public String getKeyspaceName() {
        return this.descriptor.ksname;
    }

    public static Pair<Descriptor, Component> tryComponentFromFilename(File dir, String name) {
        try {
            return Component.fromFilename(dir, name);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Set<Component> componentsFor(Descriptor desc) {
        try {
            try {
                return SSTable.readTOC(desc);
            }
            catch (FileNotFoundException e) {
                Set<Component> components = SSTable.discoverComponentsFor(desc);
                if (components.isEmpty()) {
                    return components;
                }
                if (!components.contains(Component.TOC)) {
                    components.add(Component.TOC);
                }
                SSTable.appendTOC(desc, components);
                return components;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static Set<Component> discoverComponentsFor(Descriptor desc) {
        Sets.SetView<Component.Type> knownTypes = Sets.difference(Component.TYPES, Collections.singleton(Component.Type.CUSTOM));
        HashSet<Component> components = Sets.newHashSetWithExpectedSize(knownTypes.size());
        for (Component.Type componentType : knownTypes) {
            Component component = new Component(componentType);
            if (!new File(desc.filenameFor(component)).exists()) continue;
            components.add(component);
        }
        return components;
    }

    protected long estimateRowsFromIndex(RandomAccessReader ifile) throws IOException {
        int keys;
        int SAMPLES_CAP = 10000;
        int BYTES_CAP = (int)Math.min(10000000L, ifile.length());
        for (keys = 0; ifile.getFilePointer() < (long)BYTES_CAP && keys < 10000; ++keys) {
            ByteBufferUtil.skipShortLength(ifile);
            RowIndexEntry.Serializer.skip(ifile);
        }
        assert (keys > 0 && ifile.getFilePointer() > 0L && ifile.length() > 0L) : "Unexpected empty index file: " + ifile;
        long estimatedRows = ifile.length() / (ifile.getFilePointer() / (long)keys);
        ifile.seek(0L);
        return estimatedRows;
    }

    public long bytesOnDisk() {
        long bytes = 0L;
        for (Component component : this.components) {
            bytes += new File(this.descriptor.filenameFor(component)).length();
        }
        return bytes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "path='" + this.getFilename() + '\'' + ')';
    }

    protected static Set<Component> readTOC(Descriptor descriptor) throws IOException {
        File tocFile = new File(descriptor.filenameFor(Component.TOC));
        List<String> componentNames = Files.readLines(tocFile, Charset.defaultCharset());
        HashSet<Component> components = Sets.newHashSetWithExpectedSize(componentNames.size());
        for (String componentName : componentNames) {
            Component component = new Component(Component.Type.fromRepresentation(componentName), componentName);
            if (!new File(descriptor.filenameFor(component)).exists()) {
                logger.error("Missing component: {}", (Object)descriptor.filenameFor(component));
                continue;
            }
            components.add(component);
        }
        return components;
    }

    protected static void appendTOC(Descriptor descriptor, Collection<Component> components) {
        File tocFile = new File(descriptor.filenameFor(Component.TOC));
        try (PrintWriter w = new PrintWriter(new FileWriter(tocFile, true));){
            for (Component component : components) {
                w.println(component.name);
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, tocFile);
        }
    }

    public synchronized void addComponents(Collection<Component> newComponents) {
        Collection<Component> componentsToAdd = Collections2.filter(newComponents, Predicates.not(Predicates.in(this.components)));
        SSTable.appendTOC(this.descriptor, componentsToAdd);
        this.components.addAll(componentsToAdd);
    }
}

