/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.StreamingHistogram;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class StatsMetadata
extends MetadataComponent {
    public static final IMetadataComponentSerializer serializer = new StatsMetadataSerializer();
    public final EstimatedHistogram estimatedRowSize;
    public final EstimatedHistogram estimatedColumnCount;
    public final ReplayPosition replayPosition;
    public final long minTimestamp;
    public final long maxTimestamp;
    public final int maxLocalDeletionTime;
    public final double compressionRatio;
    public final StreamingHistogram estimatedTombstoneDropTime;
    public final int sstableLevel;
    public final List<ByteBuffer> maxColumnNames;
    public final List<ByteBuffer> minColumnNames;
    public final boolean hasLegacyCounterShards;
    public final long repairedAt;

    public StatsMetadata(EstimatedHistogram estimatedRowSize, EstimatedHistogram estimatedColumnCount, ReplayPosition replayPosition, long minTimestamp, long maxTimestamp, int maxLocalDeletionTime, double compressionRatio, StreamingHistogram estimatedTombstoneDropTime, int sstableLevel, List<ByteBuffer> minColumnNames, List<ByteBuffer> maxColumnNames, boolean hasLegacyCounterShards, long repairedAt) {
        this.estimatedRowSize = estimatedRowSize;
        this.estimatedColumnCount = estimatedColumnCount;
        this.replayPosition = replayPosition;
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.maxLocalDeletionTime = maxLocalDeletionTime;
        this.compressionRatio = compressionRatio;
        this.estimatedTombstoneDropTime = estimatedTombstoneDropTime;
        this.sstableLevel = sstableLevel;
        this.minColumnNames = minColumnNames;
        this.maxColumnNames = maxColumnNames;
        this.hasLegacyCounterShards = hasLegacyCounterShards;
        this.repairedAt = repairedAt;
    }

    @Override
    public MetadataType getType() {
        return MetadataType.STATS;
    }

    public double getEstimatedDroppableTombstoneRatio(int gcBefore) {
        long estimatedColumnCount = this.estimatedColumnCount.mean() * this.estimatedColumnCount.count();
        if (estimatedColumnCount > 0L) {
            double droppable = this.getDroppableTombstonesBefore(gcBefore);
            return droppable / (double)estimatedColumnCount;
        }
        return 0.0;
    }

    public double getDroppableTombstonesBefore(int gcBefore) {
        return this.estimatedTombstoneDropTime.sum(gcBefore);
    }

    public StatsMetadata mutateLevel(int newLevel) {
        return new StatsMetadata(this.estimatedRowSize, this.estimatedColumnCount, this.replayPosition, this.minTimestamp, this.maxTimestamp, this.maxLocalDeletionTime, this.compressionRatio, this.estimatedTombstoneDropTime, newLevel, this.minColumnNames, this.maxColumnNames, this.hasLegacyCounterShards, this.repairedAt);
    }

    public StatsMetadata mutateRepairedAt(long newRepairedAt) {
        return new StatsMetadata(this.estimatedRowSize, this.estimatedColumnCount, this.replayPosition, this.minTimestamp, this.maxTimestamp, this.maxLocalDeletionTime, this.compressionRatio, this.estimatedTombstoneDropTime, this.sstableLevel, this.minColumnNames, this.maxColumnNames, this.hasLegacyCounterShards, newRepairedAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsMetadata that = (StatsMetadata)o;
        return new EqualsBuilder().append(this.estimatedRowSize, that.estimatedRowSize).append(this.estimatedColumnCount, that.estimatedColumnCount).append(this.replayPosition, that.replayPosition).append(this.minTimestamp, that.minTimestamp).append(this.maxTimestamp, that.maxTimestamp).append(this.maxLocalDeletionTime, that.maxLocalDeletionTime).append(this.compressionRatio, that.compressionRatio).append(this.estimatedTombstoneDropTime, that.estimatedTombstoneDropTime).append(this.sstableLevel, that.sstableLevel).append(this.repairedAt, that.repairedAt).append(this.maxColumnNames, that.maxColumnNames).append(this.minColumnNames, that.minColumnNames).append(this.hasLegacyCounterShards, that.hasLegacyCounterShards).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.estimatedRowSize).append(this.estimatedColumnCount).append(this.replayPosition).append(this.minTimestamp).append(this.maxTimestamp).append(this.maxLocalDeletionTime).append(this.compressionRatio).append(this.estimatedTombstoneDropTime).append(this.sstableLevel).append(this.repairedAt).append(this.maxColumnNames).append(this.minColumnNames).append(this.hasLegacyCounterShards).build();
    }

    public static class StatsMetadataSerializer
    implements IMetadataComponentSerializer<StatsMetadata> {
        @Override
        public int serializedSize(StatsMetadata component) throws IOException {
            int size = 0;
            size = (int)((long)size + EstimatedHistogram.serializer.serializedSize(component.estimatedRowSize, TypeSizes.NATIVE));
            size = (int)((long)size + EstimatedHistogram.serializer.serializedSize(component.estimatedColumnCount, TypeSizes.NATIVE));
            size = (int)((long)size + ReplayPosition.serializer.serializedSize(component.replayPosition, TypeSizes.NATIVE));
            size += 36;
            size = (int)((long)size + StreamingHistogram.serializer.serializedSize(component.estimatedTombstoneDropTime, TypeSizes.NATIVE));
            size += TypeSizes.NATIVE.sizeof(component.sstableLevel);
            size += 4;
            for (ByteBuffer columnName : component.minColumnNames) {
                size += 2 + columnName.remaining();
            }
            size += 4;
            for (ByteBuffer columnName : component.maxColumnNames) {
                size += 2 + columnName.remaining();
            }
            return size += TypeSizes.NATIVE.sizeof(component.hasLegacyCounterShards);
        }

        @Override
        public void serialize(StatsMetadata component, DataOutputPlus out) throws IOException {
            EstimatedHistogram.serializer.serialize(component.estimatedRowSize, out);
            EstimatedHistogram.serializer.serialize(component.estimatedColumnCount, out);
            ReplayPosition.serializer.serialize(component.replayPosition, out);
            out.writeLong(component.minTimestamp);
            out.writeLong(component.maxTimestamp);
            out.writeInt(component.maxLocalDeletionTime);
            out.writeDouble(component.compressionRatio);
            StreamingHistogram.serializer.serialize(component.estimatedTombstoneDropTime, out);
            out.writeInt(component.sstableLevel);
            out.writeLong(component.repairedAt);
            out.writeInt(component.minColumnNames.size());
            for (ByteBuffer columnName : component.minColumnNames) {
                ByteBufferUtil.writeWithShortLength(columnName, out);
            }
            out.writeInt(component.maxColumnNames.size());
            for (ByteBuffer columnName : component.maxColumnNames) {
                ByteBufferUtil.writeWithShortLength(columnName, out);
            }
            out.writeBoolean(component.hasLegacyCounterShards);
        }

        @Override
        public StatsMetadata deserialize(Version version, DataInput in) throws IOException {
            EstimatedHistogram rowSizes = EstimatedHistogram.serializer.deserialize(in);
            EstimatedHistogram columnCounts = EstimatedHistogram.serializer.deserialize(in);
            ReplayPosition replayPosition = ReplayPosition.serializer.deserialize(in);
            long minTimestamp = in.readLong();
            long maxTimestamp = in.readLong();
            int maxLocalDeletionTime = in.readInt();
            double compressionRatio = in.readDouble();
            StreamingHistogram tombstoneHistogram = StreamingHistogram.serializer.deserialize(in);
            int sstableLevel = in.readInt();
            long repairedAt = 0L;
            if (version.hasRepairedAt()) {
                repairedAt = in.readLong();
            }
            int colCount = in.readInt();
            ArrayList<ByteBuffer> minColumnNames = new ArrayList<ByteBuffer>(colCount);
            for (int i = 0; i < colCount; ++i) {
                minColumnNames.add(ByteBufferUtil.readWithShortLength(in));
            }
            colCount = in.readInt();
            ArrayList<ByteBuffer> maxColumnNames = new ArrayList<ByteBuffer>(colCount);
            for (int i = 0; i < colCount; ++i) {
                maxColumnNames.add(ByteBufferUtil.readWithShortLength(in));
            }
            boolean hasLegacyCounterShards = true;
            if (version.tracksLegacyCounterShards()) {
                hasLegacyCounterShards = in.readBoolean();
            }
            return new StatsMetadata(rowSizes, columnCounts, replayPosition, minTimestamp, maxTimestamp, maxLocalDeletionTime, compressionRatio, tombstoneHistogram, sstableLevel, minColumnNames, maxColumnNames, hasLegacyCounterShards, repairedAt);
        }
    }
}

