/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;

public class NIODataInputStream
extends InputStream
implements DataInput,
Closeable {
    private final ReadableByteChannel rbc;
    private final ByteBuffer buf;

    public NIODataInputStream(ReadableByteChannel rbc, int bufferSize) {
        Preconditions.checkNotNull(rbc);
        Preconditions.checkArgument(bufferSize >= 8, "Buffer size must be large enough to accomadate a long/double");
        this.rbc = rbc;
        this.buf = ByteBuffer.allocateDirect(bufferSize);
        this.buf.position(0);
        this.buf.limit(0);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int read;
        for (int copied = 0; copied < len; copied += read) {
            read = this.read(b, off + copied, len - copied);
            if (read >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int copied = 0;
        while (copied < len) {
            if (this.buf.hasRemaining()) {
                int toCopy = Math.min(len - copied, this.buf.remaining());
                this.buf.get(b, off + copied, toCopy);
                copied += toCopy;
                continue;
            }
            int read = this.readNext();
            if (read < 0 && copied == 0) {
                return -1;
            }
            if (read > 0) continue;
            return copied;
        }
        return copied;
    }

    private int readNext() throws IOException {
        Preconditions.checkState(this.buf.remaining() != this.buf.capacity());
        assert (this.buf.remaining() < 8);
        if (this.buf.position() == 0 && this.buf.hasRemaining()) {
            this.buf.position(this.buf.limit());
        } else if (this.buf.hasRemaining()) {
            ByteBuffer dup = this.buf.duplicate();
            this.buf.clear();
            this.buf.put(dup);
        } else {
            this.buf.position(0);
        }
        this.buf.limit(this.buf.capacity());
        int read = 0;
        while ((read = this.rbc.read(this.buf)) == 0) {
        }
        this.buf.flip();
        return read;
    }

    private void readMinimum(int minimum) throws IOException {
        assert (this.buf.remaining() < 8);
        while (this.buf.remaining() < minimum) {
            int read = this.readNext();
            if (read != -1) continue;
            this.buf.position(0);
            this.buf.limit(0);
            throw new EOFException();
        }
    }

    private void prepareReadPrimitive(int minimum) throws IOException {
        if (this.buf.remaining() < minimum) {
            this.readMinimum(minimum);
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skipped;
        int skippedThisTime;
        for (skipped = 0; skipped < n && (skippedThisTime = (int)this.skip(n - skipped)) > 0; skipped += skippedThisTime) {
        }
        return skipped;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.prepareReadPrimitive(1);
        return this.buf.get() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.prepareReadPrimitive(1);
        return this.buf.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.prepareReadPrimitive(1);
        return this.buf.get() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.prepareReadPrimitive(2);
        return this.buf.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.prepareReadPrimitive(2);
        return this.buf.getChar();
    }

    @Override
    public int readInt() throws IOException {
        this.prepareReadPrimitive(4);
        return this.buf.getInt();
    }

    @Override
    public long readLong() throws IOException {
        this.prepareReadPrimitive(8);
        return this.buf.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.prepareReadPrimitive(4);
        return this.buf.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.prepareReadPrimitive(8);
        return this.buf.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void close() throws IOException {
        this.rbc.close();
    }

    @Override
    public int read() throws IOException {
        return this.readUnsignedByte();
    }

    @Override
    public int available() throws IOException {
        if (this.rbc instanceof SeekableByteChannel) {
            SeekableByteChannel sbc = (SeekableByteChannel)this.rbc;
            long remainder = Math.max(0L, sbc.size() - sbc.position());
            return remainder > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(remainder + (long)this.buf.remaining());
        }
        return this.buf.remaining();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

