/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;

public class OldNetworkTopologyStrategy
extends AbstractReplicationStrategy {
    public OldNetworkTopologyStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(keyspaceName, tokenMetadata, snitch, configOptions);
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token token, TokenMetadata metadata) {
        Token t;
        int replicas = this.getReplicationFactor();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        ArrayList<Token> tokens = metadata.sortedTokens();
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter2 = TokenMetadata.ringIterator(tokens, token, false);
        Token primaryToken = iter2.next();
        endpoints.add(metadata.getEndpoint(primaryToken));
        boolean bDataCenter = false;
        boolean bOtherRack = false;
        while (endpoints.size() < replicas && iter2.hasNext()) {
            t = iter2.next();
            if (!this.snitch.getDatacenter(metadata.getEndpoint(primaryToken)).equals(this.snitch.getDatacenter(metadata.getEndpoint(t)))) {
                if (bDataCenter) continue;
                endpoints.add(metadata.getEndpoint(t));
                bDataCenter = true;
                continue;
            }
            if (this.snitch.getRack(metadata.getEndpoint(primaryToken)).equals(this.snitch.getRack(metadata.getEndpoint(t))) || !this.snitch.getDatacenter(metadata.getEndpoint(primaryToken)).equals(this.snitch.getDatacenter(metadata.getEndpoint(t))) || bOtherRack) continue;
            endpoints.add(metadata.getEndpoint(t));
            bOtherRack = true;
        }
        if (endpoints.size() < replicas) {
            iter2 = TokenMetadata.ringIterator(tokens, token, false);
            while (endpoints.size() < replicas && iter2.hasNext()) {
                t = iter2.next();
                if (endpoints.contains(metadata.getEndpoint(t))) continue;
                endpoints.add(metadata.getEndpoint(t));
            }
        }
        return endpoints;
    }

    @Override
    public int getReplicationFactor() {
        return Integer.parseInt((String)this.configOptions.get("replication_factor"));
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        if (this.configOptions == null || this.configOptions.get("replication_factor") == null) {
            throw new ConfigurationException("SimpleStrategy requires a replication_factor strategy option.");
        }
        this.validateReplicationFactor((String)this.configOptions.get("replication_factor"));
    }

    @Override
    public Collection<String> recognizedOptions() {
        return Collections.singleton("replication_factor");
    }
}

