/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.RatioGauge;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;

public class CacheMetrics {
    public final Gauge<Long> capacity;
    public final Meter hits;
    public final Meter requests;
    public final Gauge<Double> hitRate;
    public final Gauge<Long> size;
    public final Gauge<Integer> entries;

    public CacheMetrics(String type, final ICache cache) {
        DefaultNameFactory factory = new DefaultNameFactory("Cache", type);
        this.capacity = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("Capacity"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return cache.capacity();
            }
        });
        this.hits = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("Hits"));
        this.requests = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("Requests"));
        this.hitRate = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("HitRate"), new RatioGauge(){

            @Override
            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(CacheMetrics.this.hits.getCount(), CacheMetrics.this.requests.getCount());
            }
        });
        this.size = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("Size"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return cache.weightedSize();
            }
        });
        this.entries = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("Entries"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return cache.size();
            }
        });
    }
}

