/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformSnapshot;
import com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.utils.EstimatedHistogram;

public class EstimatedHistogramReservoir
implements Reservoir {
    EstimatedHistogram histogram;

    public EstimatedHistogramReservoir() {
        this(164);
    }

    public EstimatedHistogramReservoir(int numBuckets) {
        this.histogram = new EstimatedHistogram(numBuckets);
    }

    @Override
    public int size() {
        return this.histogram.getBucketOffsets().length + 1;
    }

    @Override
    public void update(long value) {
        this.histogram.add(value);
    }

    @Override
    public Snapshot getSnapshot() {
        return new HistogramSnapshot(this.histogram);
    }

    @VisibleForTesting
    public void clear() {
        this.histogram.getBuckets(true);
    }

    static class HistogramSnapshot
    extends UniformSnapshot {
        EstimatedHistogram histogram;

        public HistogramSnapshot(EstimatedHistogram histogram) {
            super(histogram.getBuckets(false));
            this.histogram = histogram;
        }

        @Override
        public double getValue(double quantile) {
            return this.histogram.percentile(quantile);
        }

        @Override
        public long getMax() {
            return this.histogram.max();
        }

        @Override
        public long getMin() {
            return this.histogram.min();
        }

        @Override
        public double getMean() {
            return this.histogram.mean();
        }
    }
}

