/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.RatioGauge;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.service.FileCacheService;

public class FileCacheMetrics {
    private static final MetricNameFactory factory = new DefaultNameFactory("FileCache");
    public final Meter hits = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("Hits"));
    public final Meter requests = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("Requests"));
    public final Gauge<Double> hitRate = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("HitRate"), new RatioGauge(){

        @Override
        public RatioGauge.Ratio getRatio() {
            return RatioGauge.Ratio.of(FileCacheMetrics.this.hits.getCount(), FileCacheMetrics.this.requests.getCount());
        }
    });
    public final Gauge<Long> size = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("Size"), new Gauge<Long>(){

        @Override
        public Long getValue() {
            return FileCacheService.instance.sizeInBytes();
        }
    });
}

