/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class LatencyMetrics {
    public final Timer latency;
    public final Counter totalLatency;
    private List<LatencyMetrics> parents = Lists.newArrayList();
    protected final MetricNameFactory factory;
    protected final String namePrefix;

    public LatencyMetrics(String type, String scope) {
        this(type, "", scope);
    }

    public LatencyMetrics(String type, String namePrefix, String scope) {
        this(new DefaultNameFactory(type, scope), namePrefix);
    }

    public LatencyMetrics(MetricNameFactory factory, String namePrefix) {
        this.factory = factory;
        this.namePrefix = namePrefix;
        this.latency = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(namePrefix + "Latency"));
        this.totalLatency = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName(namePrefix + "TotalLatency"));
    }

    public LatencyMetrics(MetricNameFactory factory, String namePrefix, LatencyMetrics ... parents) {
        this(factory, namePrefix);
        this.parents.addAll(ImmutableList.copyOf(parents));
    }

    public void addNano(long nanos) {
        this.latency.update(nanos, TimeUnit.NANOSECONDS);
        this.totalLatency.inc(nanos / 1000L);
        for (LatencyMetrics parent : this.parents) {
            parent.addNano(nanos);
        }
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "Latency"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "TotalLatency"));
    }
}

