/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.ThreadPoolMetricNameFactory;

public class ThreadPoolMetrics {
    public final Gauge<Integer> activeTasks;
    public final Counter totalBlocked;
    public final Counter currentBlocked;
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Integer> maxPoolSize;
    private MetricNameFactory factory;

    public ThreadPoolMetrics(final ThreadPoolExecutor executor, String path, String poolName) {
        this.factory = new ThreadPoolMetricNameFactory("ThreadPools", path, poolName);
        this.activeTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("ActiveTasks"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return executor.getActiveCount();
            }
        });
        this.totalBlocked = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName("TotalBlockedTasks"));
        this.currentBlocked = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName("CurrentlyBlockedTasks"));
        this.completedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("CompletedTasks"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return executor.getCompletedTaskCount();
            }
        });
        this.pendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("PendingTasks"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return executor.getTaskCount() - executor.getCompletedTaskCount();
            }
        });
        this.maxPoolSize = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("MaxPoolSize"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return executor.getMaximumPoolSize();
            }
        });
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("ActiveTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("PendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("CompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("TotalBlockedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("CurrentlyBlockedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("MaxPoolSize"));
    }

    public static Object getJmxMetric(MBeanServerConnection mbeanServerConn, String jmxPath, String poolName, String metricName) {
        String name = String.format("org.apache.cassandra.metrics:type=ThreadPools,path=%s,scope=%s,name=%s", jmxPath, poolName, metricName);
        try {
            ObjectName oName = new ObjectName(name);
            if (!mbeanServerConn.isRegistered(oName)) {
                return "N/A";
            }
            switch (metricName) {
                case "ActiveTasks": 
                case "PendingTasks": 
                case "CompletedTasks": {
                    return JMX.newMBeanProxy(mbeanServerConn, oName, JmxReporter.JmxGaugeMBean.class).getValue();
                }
                case "TotalBlockedTasks": 
                case "CurrentlyBlockedTasks": {
                    return JMX.newMBeanProxy(mbeanServerConn, oName, JmxReporter.JmxCounterMBean.class).getCount();
                }
            }
            throw new AssertionError((Object)("Unknown metric name " + metricName));
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading: " + name, e);
        }
    }
}

