/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.UUIDSerializer;

public class RepairJobDesc {
    public static final IVersionedSerializer<RepairJobDesc> serializer = new RepairJobDescSerializer();
    public final UUID parentSessionId;
    public final UUID sessionId;
    public final String keyspace;
    public final String columnFamily;
    public final Range<Token> range;

    public RepairJobDesc(UUID parentSessionId, UUID sessionId, String keyspace, String columnFamily, Range<Token> range) {
        this.parentSessionId = parentSessionId;
        this.sessionId = sessionId;
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.range = range;
    }

    public String toString() {
        return "[repair #" + this.sessionId + " on " + this.keyspace + "/" + this.columnFamily + ", " + this.range + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepairJobDesc that = (RepairJobDesc)o;
        if (!this.columnFamily.equals(that.columnFamily)) {
            return false;
        }
        if (!this.keyspace.equals(that.keyspace)) {
            return false;
        }
        if (this.range != null ? !this.range.equals(that.range) : that.range != null) {
            return false;
        }
        if (!this.sessionId.equals(that.sessionId)) {
            return false;
        }
        return !(this.parentSessionId != null ? !this.parentSessionId.equals(that.parentSessionId) : that.parentSessionId != null);
    }

    public int hashCode() {
        return Objects.hashCode(this.sessionId, this.keyspace, this.columnFamily, this.range);
    }

    private static class RepairJobDescSerializer
    implements IVersionedSerializer<RepairJobDesc> {
        private RepairJobDescSerializer() {
        }

        @Override
        public void serialize(RepairJobDesc desc, DataOutputPlus out, int version) throws IOException {
            if (version >= 8) {
                out.writeBoolean(desc.parentSessionId != null);
                if (desc.parentSessionId != null) {
                    UUIDSerializer.serializer.serialize(desc.parentSessionId, out, version);
                }
            }
            UUIDSerializer.serializer.serialize(desc.sessionId, out, version);
            out.writeUTF(desc.keyspace);
            out.writeUTF(desc.columnFamily);
            MessagingService.validatePartitioner(desc.range);
            AbstractBounds.tokenSerializer.serialize(desc.range, out, version);
        }

        @Override
        public RepairJobDesc deserialize(DataInput in, int version) throws IOException {
            UUID parentSessionId = null;
            if (version >= 8 && in.readBoolean()) {
                parentSessionId = UUIDSerializer.serializer.deserialize(in, version);
            }
            UUID sessionId = UUIDSerializer.serializer.deserialize(in, version);
            String keyspace = in.readUTF();
            String columnFamily = in.readUTF();
            Range range = (Range)AbstractBounds.tokenSerializer.deserialize(in, MessagingService.globalPartitioner(), version);
            return new RepairJobDesc(parentSessionId, sessionId, keyspace, columnFamily, range);
        }

        @Override
        public long serializedSize(RepairJobDesc desc, int version) {
            int size = 0;
            if (version >= 8) {
                size += TypeSizes.NATIVE.sizeof(desc.parentSessionId != null);
                if (desc.parentSessionId != null) {
                    size = (int)((long)size + UUIDSerializer.serializer.serializedSize(desc.parentSessionId, version));
                }
            }
            size = (int)((long)size + UUIDSerializer.serializer.serializedSize(desc.sessionId, version));
            size += TypeSizes.NATIVE.sizeof(desc.keyspace);
            size += TypeSizes.NATIVE.sizeof(desc.columnFamily);
            size = (int)((long)size + AbstractBounds.tokenSerializer.serializedSize(desc.range, version));
            return size;
        }
    }
}

