/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AsyncRepairCallback;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.RowDataResolver;
import org.apache.cassandra.service.RowDigestResolver;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCallback<TMessage, TResolved>
implements IAsyncCallbackWithFailure<TMessage> {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCallback.class);
    public final IResponseResolver<TMessage, TResolved> resolver;
    private final SimpleCondition condition = new SimpleCondition();
    final long start;
    final int blockfor;
    final List<InetAddress> endpoints;
    private final IReadCommand command;
    private final ConsistencyLevel consistencyLevel;
    private static final AtomicIntegerFieldUpdater<ReadCallback> recievedUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadCallback.class, "received");
    private volatile int received = 0;
    private static final AtomicIntegerFieldUpdater<ReadCallback> failuresUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadCallback.class, "failures");
    private volatile int failures = 0;
    private final Keyspace keyspace;

    public ReadCallback(IResponseResolver<TMessage, TResolved> resolver, ConsistencyLevel consistencyLevel, IReadCommand command, List<InetAddress> filteredEndpoints) {
        this(resolver, consistencyLevel, consistencyLevel.blockFor(Keyspace.open(command.getKeyspace())), command, Keyspace.open(command.getKeyspace()), filteredEndpoints);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Blockfor is %s; setting up requests to %s", this.blockfor, StringUtils.join(this.endpoints, ",")));
        }
    }

    public ReadCallback(IResponseResolver<TMessage, TResolved> resolver, ConsistencyLevel consistencyLevel, int blockfor, IReadCommand command, Keyspace keyspace, List<InetAddress> endpoints) {
        this.command = command;
        this.keyspace = keyspace;
        this.blockfor = blockfor;
        this.consistencyLevel = consistencyLevel;
        this.resolver = resolver;
        this.start = System.nanoTime();
        this.endpoints = endpoints;
        assert (!(resolver instanceof RangeSliceResponseResolver) || blockfor >= endpoints.size());
    }

    public boolean await(long timePastStart, TimeUnit unit) {
        long time = unit.toNanos(timePastStart) - (System.nanoTime() - this.start);
        try {
            return this.condition.await(time, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public TResolved get() throws ReadFailureException, ReadTimeoutException, DigestMismatchException {
        if (!this.await(this.command.getTimeout(), TimeUnit.MILLISECONDS)) {
            ReadTimeoutException ex = new ReadTimeoutException(this.consistencyLevel, this.received, this.blockfor, this.resolver.isDataPresent());
            Tracing.trace("Read timeout: {}", (Object)ex.toString());
            if (logger.isTraceEnabled()) {
                logger.trace("Read timeout: {}", (Object)ex.toString());
            }
            throw ex;
        }
        if (this.blockfor + this.failures > this.endpoints.size()) {
            ReadFailureException ex = new ReadFailureException(this.consistencyLevel, this.received, this.failures, this.blockfor, this.resolver.isDataPresent());
            if (logger.isTraceEnabled()) {
                logger.trace("Read failure: {}", (Object)ex.toString());
            }
            throw ex;
        }
        return this.blockfor == 1 ? this.resolver.getData() : this.resolver.resolve();
    }

    @Override
    public void response(MessageIn<TMessage> message) {
        int n;
        this.resolver.preprocess(message);
        int n2 = n = this.waitingFor(message.from) ? recievedUpdater.incrementAndGet(this) : this.received;
        if (n >= this.blockfor && this.resolver.isDataPresent()) {
            this.condition.signalAll();
            if (this.blockfor < this.endpoints.size() && n == this.endpoints.size()) {
                TraceState traceState = Tracing.instance.get();
                if (traceState != null) {
                    traceState.trace("Initiating read-repair");
                }
                StageManager.getStage(Stage.READ_REPAIR).execute(new AsyncRepairRunner(traceState));
            }
        }
    }

    private boolean waitingFor(InetAddress from) {
        return this.consistencyLevel.isDatacenterLocal() ? DatabaseDescriptor.getLocalDataCenter().equals(DatabaseDescriptor.getEndpointSnitch().getDatacenter(from)) : true;
    }

    public int getReceivedCount() {
        return this.received;
    }

    public void response(TMessage result) {
        MessageIn<TMessage> message = MessageIn.create(FBUtilities.getBroadcastAddress(), result, Collections.emptyMap(), MessagingService.Verb.INTERNAL_RESPONSE, 9);
        this.response((TMessage)message);
    }

    public void assureSufficientLiveNodes() throws UnavailableException {
        this.consistencyLevel.assureSufficientLiveNodes(this.keyspace, this.endpoints);
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }

    @Override
    public void onFailure(InetAddress from) {
        int n;
        int n2 = n = this.waitingFor(from) ? failuresUpdater.incrementAndGet(this) : this.failures;
        if (this.blockfor + n > this.endpoints.size()) {
            this.condition.signalAll();
        }
    }

    private class AsyncRepairRunner
    implements Runnable {
        private final TraceState traceState;

        public AsyncRepairRunner(TraceState traceState) {
            this.traceState = traceState;
        }

        @Override
        public void run() {
            try {
                ReadCallback.this.resolver.resolve();
            }
            catch (DigestMismatchException e) {
                assert (ReadCallback.this.resolver instanceof RowDigestResolver);
                if (this.traceState != null) {
                    this.traceState.trace("Digest mismatch: {}", e.toString());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Digest mismatch:", e);
                }
                ReadRepairMetrics.repairedBackground.mark();
                ReadCommand readCommand = (ReadCommand)ReadCallback.this.command;
                RowDataResolver repairResolver = new RowDataResolver(readCommand.ksName, readCommand.key, readCommand.filter(), readCommand.timestamp, ReadCallback.this.endpoints.size());
                AsyncRepairCallback repairHandler = new AsyncRepairCallback(repairResolver, ReadCallback.this.endpoints.size());
                MessageOut<ReadCommand> message = ((ReadCommand)ReadCallback.this.command).createMessage();
                for (InetAddress endpoint : ReadCallback.this.endpoints) {
                    MessagingService.instance().sendRR(message, endpoint, repairHandler);
                }
            }
        }
    }
}

