/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.pager.QueryPager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractQueryPager
implements QueryPager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQueryPager.class);
    private final ConsistencyLevel consistencyLevel;
    private final boolean localQuery;
    protected final CFMetaData cfm;
    protected final IDiskAtomFilter columnFilter;
    private final long timestamp;
    private int remaining;
    private boolean exhausted;
    private boolean shouldFetchExtraRow;

    protected AbstractQueryPager(ConsistencyLevel consistencyLevel, int toFetch, boolean localQuery, String keyspace, String columnFamily, IDiskAtomFilter columnFilter, long timestamp) {
        this(consistencyLevel, toFetch, localQuery, Schema.instance.getCFMetaData(keyspace, columnFamily), columnFilter, timestamp);
    }

    protected AbstractQueryPager(ConsistencyLevel consistencyLevel, int toFetch, boolean localQuery, CFMetaData cfm, IDiskAtomFilter columnFilter, long timestamp) {
        this.consistencyLevel = consistencyLevel;
        this.localQuery = localQuery;
        this.cfm = cfm;
        this.columnFilter = columnFilter;
        this.timestamp = timestamp;
        this.remaining = toFetch;
    }

    @Override
    public List<Row> fetchPage(int pageSize) throws RequestValidationException, RequestExecutionException {
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        int currentPageSize = this.nextPageSize(pageSize);
        List<Row> rows = this.filterEmpty(this.queryNextPage(currentPageSize, this.consistencyLevel, this.localQuery));
        if (rows.isEmpty()) {
            logger.debug("Got empty set of rows, considering pager exhausted");
            this.exhausted = true;
            return Collections.emptyList();
        }
        int liveCount = this.getPageLiveCount(rows);
        logger.debug("Fetched {} live rows", (Object)liveCount);
        if (liveCount > currentPageSize) {
            rows = this.discardLast(rows, liveCount - currentPageSize);
            liveCount = currentPageSize;
        }
        this.remaining -= liveCount;
        if (liveCount < currentPageSize) {
            logger.debug("Got result ({}) smaller than page size ({}), considering pager exhausted", (Object)liveCount, (Object)currentPageSize);
            this.exhausted = true;
        }
        if (this.containsPreviousLast(rows.get(0))) {
            rows = this.discardFirst(rows);
            ++this.remaining;
        } else if (this.shouldFetchExtraRow && !this.exhausted) {
            rows = this.discardLast(rows);
            ++this.remaining;
        }
        logger.debug("Remaining rows to page: {}", (Object)this.remaining);
        if (!this.isExhausted()) {
            this.shouldFetchExtraRow = this.recordLast(rows.get(rows.size() - 1));
        }
        return rows;
    }

    private List<Row> filterEmpty(List<Row> result) {
        for (Row row : result) {
            if (row.cf != null && row.cf.hasColumns()) continue;
            ArrayList<Row> newResult = new ArrayList<Row>(result.size() - 1);
            for (Row row2 : result) {
                if (row2.cf == null || !row2.cf.hasColumns()) continue;
                newResult.add(row2);
            }
            return newResult;
        }
        return result;
    }

    protected void restoreState(int remaining, boolean shouldFetchExtraRow) {
        this.remaining = remaining;
        this.shouldFetchExtraRow = shouldFetchExtraRow;
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted || this.remaining == 0;
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    public long timestamp() {
        return this.timestamp;
    }

    private int nextPageSize(int pageSize) {
        return Math.min(this.remaining, pageSize) + (this.shouldFetchExtraRow ? 1 : 0);
    }

    public ColumnCounter columnCounter() {
        return this.columnFilter.columnCounter(this.cfm.comparator, this.timestamp);
    }

    protected abstract List<Row> queryNextPage(int var1, ConsistencyLevel var2, boolean var3) throws RequestValidationException, RequestExecutionException;

    protected abstract boolean containsPreviousLast(Row var1);

    protected abstract boolean recordLast(Row var1);

    protected abstract boolean isReversed();

    private List<Row> discardFirst(List<Row> rows) {
        return this.discardFirst(rows, 1);
    }

    @VisibleForTesting
    List<Row> discardFirst(List<Row> rows, int toDiscard) {
        if (toDiscard == 0 || rows.isEmpty()) {
            return rows;
        }
        int i = 0;
        DecoratedKey firstKey = null;
        ColumnFamily firstCf = null;
        while (toDiscard > 0 && i < rows.size()) {
            Row first = rows.get(i++);
            firstKey = first.key;
            firstCf = first.cf.cloneMeShallow(this.isReversed());
            toDiscard -= this.isReversed() ? this.discardLast(first.cf, toDiscard, firstCf) : this.discardFirst(first.cf, toDiscard, firstCf);
        }
        if (toDiscard > 0) {
            return Collections.emptyList();
        }
        int count = firstCf.getColumnCount();
        int newSize = rows.size() - (count == 0 ? i : i - 1);
        ArrayList<Row> newRows = new ArrayList<Row>(newSize);
        if (count != 0) {
            newRows.add(new Row(firstKey, firstCf));
        }
        newRows.addAll(rows.subList(i, rows.size()));
        return newRows;
    }

    private List<Row> discardLast(List<Row> rows) {
        return this.discardLast(rows, 1);
    }

    @VisibleForTesting
    List<Row> discardLast(List<Row> rows, int toDiscard) {
        if (toDiscard == 0 || rows.isEmpty()) {
            return rows;
        }
        int i = rows.size() - 1;
        DecoratedKey lastKey = null;
        ColumnFamily lastCf = null;
        while (toDiscard > 0 && i >= 0) {
            Row last = rows.get(i--);
            lastKey = last.key;
            lastCf = last.cf.cloneMeShallow(this.isReversed());
            toDiscard -= this.isReversed() ? this.discardFirst(last.cf, toDiscard, lastCf) : this.discardLast(last.cf, toDiscard, lastCf);
        }
        if (toDiscard > 0) {
            return Collections.emptyList();
        }
        int count = lastCf.getColumnCount();
        int newSize = count == 0 ? i + 1 : i + 2;
        ArrayList<Row> newRows = new ArrayList<Row>(newSize);
        newRows.addAll(rows.subList(0, i + 1));
        if (count != 0) {
            newRows.add(new Row(lastKey, lastCf));
        }
        return newRows;
    }

    private int getPageLiveCount(List<Row> page) {
        int count = 0;
        for (Row row : page) {
            count += this.columnCounter().countAll(row.cf).live();
        }
        return count;
    }

    private int discardFirst(ColumnFamily cf, int toDiscard, ColumnFamily newCf) {
        boolean isReversed = this.isReversed();
        DeletionInfo.InOrderTester tester = cf.deletionInfo().inOrderTester(isReversed);
        return isReversed ? this.discardTail(cf, toDiscard, newCf, cf.reverseIterator(), tester) : this.discardHead(toDiscard, newCf, cf.iterator(), tester);
    }

    private int discardLast(ColumnFamily cf, int toDiscard, ColumnFamily newCf) {
        boolean isReversed = this.isReversed();
        DeletionInfo.InOrderTester tester = cf.deletionInfo().inOrderTester(isReversed);
        return isReversed ? this.discardHead(toDiscard, newCf, cf.reverseIterator(), tester) : this.discardTail(cf, toDiscard, newCf, cf.iterator(), tester);
    }

    private int discardHead(int toDiscard, ColumnFamily copy, Iterator<Cell> iter2, DeletionInfo.InOrderTester tester) {
        ColumnCounter counter = this.columnCounter();
        ArrayList<Cell> staticCells = new ArrayList<Cell>(this.cfm.staticColumns().size());
        while (iter2.hasNext()) {
            Cell c = iter2.next();
            ColumnDefinition columnDef = this.cfm.getColumnDefinition(c.name());
            if (columnDef != null && columnDef.kind == ColumnDefinition.Kind.STATIC) {
                staticCells.add(c);
                continue;
            }
            counter.count(c, tester);
            if (counter.live() <= toDiscard) continue;
            for (Cell staticCell : staticCells) {
                copy.addColumn(staticCell);
            }
            copy.addColumn(c);
            while (iter2.hasNext()) {
                copy.addColumn(iter2.next());
            }
        }
        return Math.min(counter.live(), toDiscard);
    }

    private int discardTail(ColumnFamily cf, int toDiscard, ColumnFamily copy, Iterator<Cell> iter2, DeletionInfo.InOrderTester tester) {
        int liveCount = this.columnCounter().countAll(cf).live();
        ColumnCounter counter = this.columnCounter();
        while (iter2.hasNext()) {
            Cell c = iter2.next();
            counter.count(c, tester);
            if (counter.live() > liveCount - toDiscard) break;
            copy.addColumn(c);
        }
        return Math.min(liveCount, toDiscard);
    }

    protected Cell firstNonStaticCell(ColumnFamily cf) {
        for (Cell cell : cf) {
            ColumnDefinition def = this.cfm.getColumnDefinition(cell.name());
            if (def != null && def.kind == ColumnDefinition.Kind.STATIC) continue;
            return cell;
        }
        return null;
    }

    protected static Cell lastCell(ColumnFamily cf) {
        return cf.getReverseSortedColumns().iterator().next();
    }
}

