/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.AsymmetricOrdering;
import org.apache.cassandra.utils.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalTree<C extends Comparable<? super C>, D, I extends Interval<C, D>>
implements Iterable<I> {
    private static final Logger logger = LoggerFactory.getLogger(IntervalTree.class);
    private static final IntervalTree EMPTY_TREE = new IntervalTree(null);
    private final IntervalNode head;
    private final int count;

    protected IntervalTree(Collection<I> intervals) {
        this.head = intervals == null || intervals.isEmpty() ? null : new IntervalNode(intervals);
        this.count = intervals == null ? 0 : intervals.size();
    }

    public static <C extends Comparable<? super C>, D, I extends Interval<C, D>> IntervalTree<C, D, I> build(Collection<I> intervals) {
        if (intervals == null || intervals.isEmpty()) {
            return IntervalTree.emptyTree();
        }
        return new IntervalTree<C, D, I>(intervals);
    }

    public static <C extends Comparable<? super C>, D, I extends Interval<C, D>> Serializer<C, D, I> serializer(ISerializer<C> pointSerializer, ISerializer<D> dataSerializer, Constructor<I> constructor) {
        return new Serializer(pointSerializer, dataSerializer, constructor);
    }

    public static <C extends Comparable<? super C>, D, I extends Interval<C, D>> IntervalTree<C, D, I> emptyTree() {
        return EMPTY_TREE;
    }

    public int intervalCount() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public C max() {
        if (this.head == null) {
            throw new IllegalStateException();
        }
        return this.head.high;
    }

    public C min() {
        if (this.head == null) {
            throw new IllegalStateException();
        }
        return this.head.low;
    }

    public List<D> search(Interval<C, D> searchInterval) {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList results = new ArrayList();
        this.head.searchInternal(searchInterval, results);
        return results;
    }

    public List<D> search(C point) {
        return this.search((C)Interval.create(point, point, null));
    }

    @Override
    public Iterator<I> iterator() {
        if (this.head == null) {
            return Iterators.emptyIterator();
        }
        return new TreeIterator(this.head);
    }

    public String toString() {
        return "<" + Joiner.on(", ").join(this) + ">";
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntervalTree)) {
            return false;
        }
        IntervalTree that = (IntervalTree)o;
        return Iterators.elementsEqual(this.iterator(), that.iterator());
    }

    public final int hashCode() {
        int result = 0;
        for (Interval interval : this) {
            result = 31 * result + interval.hashCode();
        }
        return result;
    }

    public static class Serializer<C extends Comparable<? super C>, D, I extends Interval<C, D>>
    implements IVersionedSerializer<IntervalTree<C, D, I>> {
        private final ISerializer<C> pointSerializer;
        private final ISerializer<D> dataSerializer;
        private final Constructor<I> constructor;

        private Serializer(ISerializer<C> pointSerializer, ISerializer<D> dataSerializer, Constructor<I> constructor) {
            this.pointSerializer = pointSerializer;
            this.dataSerializer = dataSerializer;
            this.constructor = constructor;
        }

        @Override
        public void serialize(IntervalTree<C, D, I> it, DataOutputPlus out, int version) throws IOException {
            out.writeInt(((IntervalTree)it).count);
            for (Interval interval : it) {
                this.pointSerializer.serialize(interval.min, out);
                this.pointSerializer.serialize(interval.max, out);
                this.dataSerializer.serialize(interval.data, out);
            }
        }

        @Override
        public IntervalTree<C, D, I> deserialize(DataInput in, int version) throws IOException {
            return this.deserialize(in, version, null);
        }

        public IntervalTree<C, D, I> deserialize(DataInput in, int version, Comparator<C> comparator) throws IOException {
            try {
                int count = in.readInt();
                ArrayList<I> intervals = new ArrayList<I>(count);
                for (int i = 0; i < count; ++i) {
                    Comparable min = (Comparable)this.pointSerializer.deserialize(in);
                    Comparable max = (Comparable)this.pointSerializer.deserialize(in);
                    D data = this.dataSerializer.deserialize(in);
                    intervals.add(this.constructor.newInstance(min, max, data));
                }
                return new IntervalTree(intervals);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public long serializedSize(IntervalTree<C, D, I> it, TypeSizes typeSizes, int version) {
            long size = typeSizes.sizeof(0);
            for (Interval interval : it) {
                size += this.pointSerializer.serializedSize(interval.min, typeSizes);
                size += this.pointSerializer.serializedSize(interval.max, typeSizes);
                size += this.dataSerializer.serializedSize(interval.data, typeSizes);
            }
            return size;
        }

        @Override
        public long serializedSize(IntervalTree<C, D, I> it, int version) {
            return this.serializedSize(it, TypeSizes.NATIVE, version);
        }
    }

    private class TreeIterator
    extends AbstractIterator<I> {
        private final Deque<IntervalNode> stack = new ArrayDeque<IntervalNode>();
        private Iterator<I> current;

        TreeIterator(IntervalNode node) {
            this.gotoMinOf(node);
        }

        @Override
        protected I computeNext() {
            if (this.current != null && this.current.hasNext()) {
                return (Interval)this.current.next();
            }
            IntervalNode node = this.stack.pollFirst();
            if (node == null) {
                return (Interval)this.endOfData();
            }
            this.current = node.intersectsLeft.iterator();
            this.gotoMinOf(node.right);
            return this.computeNext();
        }

        private void gotoMinOf(IntervalNode node) {
            while (node != null) {
                this.stack.offerFirst(node);
                node = node.left;
            }
        }
    }

    private class IntervalNode {
        final C center;
        final C low;
        final C high;
        final List<I> intersectsLeft;
        final List<I> intersectsRight;
        final IntervalNode left;
        final IntervalNode right;

        public IntervalNode(Collection<I> toBisect) {
            assert (!toBisect.isEmpty());
            logger.trace("Creating IntervalNode from {}", (Object)toBisect);
            if (toBisect.size() == 1) {
                Interval interval = (Interval)toBisect.iterator().next();
                this.low = (Comparable)interval.min;
                this.center = (Comparable)interval.max;
                this.high = (Comparable)interval.max;
                List<Interval> l = Collections.singletonList(interval);
                this.intersectsLeft = l;
                this.intersectsRight = l;
                this.left = null;
                this.right = null;
            } else {
                ArrayList allEndpoints = new ArrayList(toBisect.size() * 2);
                for (Interval interval : toBisect) {
                    allEndpoints.add(interval.min);
                    allEndpoints.add(interval.max);
                }
                Collections.sort(allEndpoints);
                this.low = (Comparable)allEndpoints.get(0);
                this.center = (Comparable)allEndpoints.get(toBisect.size());
                this.high = (Comparable)allEndpoints.get(allEndpoints.size() - 1);
                ArrayList<Interval> intersects = new ArrayList<Interval>();
                ArrayList<Interval> leftSegment = new ArrayList<Interval>();
                ArrayList<Interval> rightSegment = new ArrayList<Interval>();
                for (Interval candidate : toBisect) {
                    if (((Comparable)candidate.max).compareTo(this.center) < 0) {
                        leftSegment.add(candidate);
                        continue;
                    }
                    if (((Comparable)candidate.min).compareTo(this.center) > 0) {
                        rightSegment.add(candidate);
                        continue;
                    }
                    intersects.add(candidate);
                }
                this.intersectsLeft = Interval.minOrdering().sortedCopy(intersects);
                this.intersectsRight = Interval.maxOrdering().sortedCopy(intersects);
                this.left = leftSegment.isEmpty() ? null : new IntervalNode(leftSegment);
                IntervalNode intervalNode = this.right = rightSegment.isEmpty() ? null : new IntervalNode(rightSegment);
                assert (intersects.size() + leftSegment.size() + rightSegment.size() == toBisect.size()) : "intersects (" + String.valueOf(intersects.size()) + ") + leftSegment (" + String.valueOf(leftSegment.size()) + ") + rightSegment (" + String.valueOf(rightSegment.size()) + ") != toBisect (" + String.valueOf(toBisect.size()) + ")";
            }
        }

        void searchInternal(Interval<C, D> searchInterval, List<D> results) {
            if (this.center.compareTo(searchInterval.min) < 0) {
                int i = Interval.maxOrdering().binarySearchAsymmetric(this.intersectsRight, searchInterval.min, AsymmetricOrdering.Op.CEIL);
                if (i == this.intersectsRight.size() && this.high.compareTo(searchInterval.min) < 0) {
                    return;
                }
                while (i < this.intersectsRight.size()) {
                    results.add(((Interval)this.intersectsRight.get((int)i++)).data);
                }
                if (this.right != null) {
                    this.right.searchInternal(searchInterval, results);
                }
            } else if (this.center.compareTo(searchInterval.max) > 0) {
                int j = Interval.minOrdering().binarySearchAsymmetric(this.intersectsLeft, searchInterval.max, AsymmetricOrdering.Op.HIGHER);
                if (j == 0 && this.low.compareTo(searchInterval.max) > 0) {
                    return;
                }
                for (int i = 0; i < j; ++i) {
                    results.add(((Interval)this.intersectsLeft.get((int)i)).data);
                }
                if (this.left != null) {
                    this.left.searchInternal(searchInterval, results);
                }
            } else {
                for (Interval interval : this.intersectsLeft) {
                    results.add(interval.data);
                }
                if (this.left != null) {
                    this.left.searchInternal(searchInterval, results);
                }
                if (this.right != null) {
                    this.right.searchInternal(searchInterval, results);
                }
            }
        }
    }
}

