/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.UUIDs;
import com.google.common.base.Function;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hawkular.metrics.core.service.TTLDataPoint;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.Tenant;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import rx.Observable;

public class Functions {
    public static final Function<List<ResultSet>, Void> TO_VOID = resultSets -> null;

    private Functions() {
    }

    public static DataPoint<Double> getGaugeDataPoint(Row row) {
        return new DataPoint<Double>(UUIDs.unixTimestamp((UUID)row.getUUID(GAUGE_COLS.TIME.ordinal())), row.getDouble(GAUGE_COLS.VALUE.ordinal()));
    }

    public static DataPoint<Long> getCounterDataPoint(Row row) {
        return new DataPoint<Long>(UUIDs.unixTimestamp((UUID)row.getUUID(COUNTER_COLS.TIME.ordinal())), row.getLong(COUNTER_COLS.VALUE.ordinal()));
    }

    public static TTLDataPoint<Double> getTTLGaugeDataPoint(Row row, int originalTTL) {
        long writeTime = row.getLong(GAUGE_COLS.WRITE_TIME.ordinal()) / 1000L;
        DataPoint<Double> dataPoint = Functions.getGaugeDataPoint(row);
        Duration duration = new Duration(DateTime.now().minus(writeTime).getMillis());
        int newTTL = originalTTL - duration.toStandardSeconds().getSeconds();
        return new TTLDataPoint<Double>(dataPoint, newTTL);
    }

    public static TTLDataPoint<AvailabilityType> getTTLAvailabilityDataPoint(Row row, int originalTTL) {
        long writeTime = row.getLong(GAUGE_COLS.WRITE_TIME.ordinal()) / 1000L;
        DataPoint<AvailabilityType> dataPoint = Functions.getAvailabilityDataPoint(row);
        Duration duration = new Duration(DateTime.now().minus(writeTime).getMillis());
        int newTTL = originalTTL - duration.toStandardSeconds().getSeconds();
        return new TTLDataPoint<AvailabilityType>(dataPoint, newTTL);
    }

    public static DataPoint<AvailabilityType> getAvailabilityDataPoint(Row row) {
        return new DataPoint<AvailabilityType>(UUIDs.unixTimestamp((UUID)row.getUUID(AVAILABILITY_COLS.TIME.ordinal())), AvailabilityType.fromBytes(row.getBytes(AVAILABILITY_COLS.AVAILABILITY.ordinal())));
    }

    public static Tenant getTenant(Row row) {
        String tenantId = row.getString(0);
        Map<MetricType<?>, Integer> retentions = row.getMap(1, String.class, Integer.class).entrySet().stream().collect(Collectors.toMap(entry -> MetricType.fromTextCode((String)entry.getKey()), Map.Entry::getValue));
        return new Tenant(tenantId, retentions);
    }

    public static <S> Observable<Metric<S>> metricToObservable(String tenantId, List<Metric<S>> metrics, MetricType<S> type) {
        return Observable.from(metrics).map(g -> new Metric(new MetricId(tenantId, type, g.getMetricId().getName()), g.getDataPoints()));
    }

    public static <T> Observable<Metric<T>> dataPointToObservable(String tenantId, String metricId, List<DataPoint<T>> points, MetricType<T> type) {
        Metric<T> metric = new Metric<T>(new MetricId<T>(tenantId, type, metricId), points);
        return Observable.just(metric);
    }

    public static String makeSafe(String s) {
        return "$" + s;
    }

    public static boolean isValidTagMap(Map<String, String> map) {
        for (String value : map.keySet()) {
            if (value != null && !value.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static enum AVAILABILITY_COLS {
        TIME,
        DATA_RETENTION,
        AVAILABILITY,
        WRITE_TIME;

    }

    private static enum COUNTER_COLS {
        TIME,
        DATA_RETENTION,
        VALUE,
        WRITE_TIME;

    }

    private static enum GAUGE_COLS {
        TIME,
        DATA_RETENTION,
        VALUE,
        WRITE_TIME;

    }
}

