/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricType;
import rx.Observable;

public class MetricTypeFilter<T>
implements Observable.Transformer<Metric<?>, Metric<T>> {
    public static final MetricTypeFilter<Double> GAUGE_FILTER = new MetricTypeFilter<Double>(MetricType.GAUGE);
    public static final MetricTypeFilter<Long> COUNTER_FILTER = new MetricTypeFilter<Long>(MetricType.COUNTER);
    public static final MetricTypeFilter<AvailabilityType> AVAILABILITY_FILTER = new MetricTypeFilter<AvailabilityType>(MetricType.AVAILABILITY);
    private final MetricType<T> metricType;

    public MetricTypeFilter(MetricType<T> metricType) {
        this.metricType = metricType;
    }

    public Observable<Metric<T>> call(Observable<Metric<?>> observable) {
        return observable.filter(metric -> metric.getMetricId().getType() == this.metricType).map(metric -> metric);
    }
}

