/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.hawkular.metrics.model.NumericBucketPoint;

final class SumNumericBucketPointCollector {
    private Sum min = new Sum();
    private Sum average = new Sum();
    private Sum median = new Sum();
    private Sum max = new Sum();
    private Sum samples = new Sum();
    private Long start;
    private Long end;

    SumNumericBucketPointCollector() {
    }

    void increment(NumericBucketPoint bucketPoint) {
        this.min.increment(bucketPoint.getMin());
        this.average.increment(bucketPoint.getAvg());
        this.median.increment(bucketPoint.getMedian());
        this.max.increment(bucketPoint.getMax());
        this.samples.increment(1.0);
        this.start = bucketPoint.getStart();
        this.end = bucketPoint.getEnd();
    }

    NumericBucketPoint toBucketPoint() {
        int localSamples = Integer.MAX_VALUE;
        if (this.samples.getN() >= Integer.MIN_VALUE && this.samples.getN() <= Integer.MAX_VALUE) {
            localSamples = (int)this.samples.getN();
        }
        return new NumericBucketPoint.Builder(this.start, this.end).setMin(this.min.getResult()).setAvg(this.average.getResult()).setMedian(this.median.getResult()).setMax(this.max.getResult()).setSamples(localSamples).build();
    }
}

