/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import com.datastax.driver.core.Row;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import rx.Observable;

public class TagsIndexRowTransformer<T>
implements Observable.Transformer<Row, MetricId<T>> {
    private final MetricType<T> type;
    private final String tenantId;

    public TagsIndexRowTransformer(String tenantId, MetricType<T> type) {
        this.type = type;
        this.tenantId = tenantId;
    }

    public Observable<MetricId<T>> call(Observable<Row> rows) {
        return rows.filter(row -> {
            MetricType<?> metricType = MetricType.fromCode(row.getByte(0));
            return this.type == null && metricType.isUserType() || metricType == this.type;
        }).map(row1 -> {
            MetricType<?> metricType = MetricType.fromCode(row1.getByte(0));
            return new MetricId(this.tenantId, metricType, row1.getString(1));
        });
    }
}

