/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hawkular.metrics.model.MetricType;

public class Tenant {
    private final String id;
    private final Map<MetricType<?>, Integer> retentionSettings;

    public Tenant(String id) {
        this(id, null);
    }

    public Tenant(String id, Map<MetricType<?>, Integer> retentionSettings) {
        Preconditions.checkArgument(id != null, "Tenant id is null");
        this.id = id;
        this.retentionSettings = retentionSettings == null ? ImmutableMap.of() : ImmutableMap.copyOf(retentionSettings);
    }

    public String getId() {
        return this.id;
    }

    public Map<MetricType<?>, Integer> getRetentionSettings() {
        return this.retentionSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return this.id.equals(tenant.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("id", this.id).add("retentionSettings", this.retentionSettings).omitNullValues().toString();
    }
}

