/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model.param;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.TimeRange;

public class BucketConfig {
    private final Buckets buckets;
    private final TimeRange timeRange;
    private final boolean valid;
    private final String problem;

    public BucketConfig(Integer bucketsCount, Duration bucketDuration, TimeRange timeRange) {
        Preconditions.checkArgument(timeRange != null, "Time range is null");
        this.timeRange = timeRange;
        if (!timeRange.isValid()) {
            throw new IllegalArgumentException("Invalid time range: " + timeRange.getProblem());
        }
        if (bucketsCount == null && bucketDuration == null) {
            this.buckets = null;
            this.valid = true;
            this.problem = null;
        } else if (bucketsCount != null && bucketDuration != null) {
            this.buckets = null;
            this.valid = false;
            this.problem = "Both buckets and bucketDuration parameters are specified";
        } else {
            Buckets buckets = null;
            IllegalArgumentException cause = null;
            try {
                buckets = bucketsCount != null ? Buckets.fromCount(timeRange.getStart(), timeRange.getEnd(), bucketsCount) : Buckets.fromStep(timeRange.getStart(), timeRange.getEnd(), bucketDuration.toMillis());
            }
            catch (IllegalArgumentException e) {
                cause = e;
            }
            this.buckets = buckets;
            if (cause == null) {
                this.valid = true;
                this.problem = null;
            } else {
                this.valid = false;
                this.problem = cause.getMessage();
            }
        }
    }

    public Buckets getBuckets() {
        return this.buckets;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isEmpty() {
        return this.buckets == null;
    }

    public String getProblem() {
        return this.problem;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("buckets", this.buckets).add("valid", this.valid).add("problem", this.problem).omitNullValues().toString();
    }
}

