/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model.param;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import java.util.concurrent.TimeUnit;

public class Duration {
    public static final ImmutableBiMap<TimeUnit, String> UNITS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().put((Object)TimeUnit.MILLISECONDS, "ms")).put((Object)TimeUnit.SECONDS, "s")).put((Object)TimeUnit.MINUTES, "mn")).put((Object)TimeUnit.HOURS, "h")).put((Object)TimeUnit.DAYS, "d")).build();
    private final long value;
    private final TimeUnit timeUnit;

    public Duration(long value, TimeUnit timeUnit) {
        Preconditions.checkArgument(timeUnit != null, "timeUnit is null");
        Preconditions.checkArgument(UNITS.containsKey((Object)timeUnit), "Invalid unit %s", new Object[]{timeUnit});
        this.value = value;
        this.timeUnit = timeUnit;
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long toMillis() {
        return TimeUnit.MILLISECONDS.convert(this.value, this.timeUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.value == duration.value && this.timeUnit == duration.timeUnit;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + this.timeUnit.hashCode();
        return result;
    }

    public String toString() {
        return "Duration[value=" + this.value + ", timeUnit=" + (Object)((Object)this.timeUnit) + ']';
    }
}

