/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Connection;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ConvictionPolicy {
    ConvictionPolicy() {
    }

    abstract void signalConnectionsOpening(int var1);

    abstract void signalConnectionClosed(Connection var1);

    abstract boolean signalConnectionFailure(Connection var1);

    abstract boolean canReconnectNow();

    static class DefaultConvictionPolicy
    extends ConvictionPolicy {
        private final Host host;
        private final ReconnectionPolicy reconnectionPolicy;
        private final AtomicInteger openConnections = new AtomicInteger();
        private volatile long nextReconnectionTime = Long.MIN_VALUE;
        private ReconnectionPolicy.ReconnectionSchedule reconnectionSchedule;

        private DefaultConvictionPolicy(Host host, ReconnectionPolicy reconnectionPolicy) {
            this.host = host;
            this.reconnectionPolicy = reconnectionPolicy;
        }

        @Override
        void signalConnectionsOpening(int count) {
            int newTotal = this.openConnections.addAndGet(count);
            Host.statesLogger.debug("[{}] preparing to open {} new connections, total = {}", this.host, count, newTotal);
            this.resetReconnectionTime();
        }

        @Override
        void signalConnectionClosed(Connection connection) {
            int remaining = this.openConnections.decrementAndGet();
            assert (remaining >= 0);
            Host.statesLogger.debug("[{}] {} closed, remaining = {}", this.host, connection, remaining);
        }

        @Override
        boolean signalConnectionFailure(Connection connection) {
            if (this.host.state != Host.State.DOWN) {
                this.updateReconnectionTime();
            }
            int remaining = this.openConnections.decrementAndGet();
            assert (remaining >= 0);
            Host.statesLogger.debug("[{}] {} failed, remaining = {}", this.host, connection, remaining);
            return remaining == 0;
        }

        private synchronized void updateReconnectionTime() {
            long now = System.nanoTime();
            if (this.nextReconnectionTime > now) {
                return;
            }
            if (this.reconnectionSchedule == null) {
                this.reconnectionSchedule = this.reconnectionPolicy.newSchedule();
            }
            long nextDelayMs = this.reconnectionSchedule.nextDelayMs();
            Host.statesLogger.debug("[{}] preventing new connections for the next {} ms", (Object)this.host, (Object)nextDelayMs);
            this.nextReconnectionTime = now + TimeUnit.NANOSECONDS.convert(nextDelayMs, TimeUnit.MILLISECONDS);
        }

        private synchronized void resetReconnectionTime() {
            this.reconnectionSchedule = null;
            this.nextReconnectionTime = Long.MIN_VALUE;
        }

        @Override
        boolean canReconnectNow() {
            boolean canReconnectNow = this.nextReconnectionTime == Long.MIN_VALUE || System.nanoTime() >= this.nextReconnectionTime;
            Host.statesLogger.trace("canReconnectNow={}", (Object)canReconnectNow);
            return canReconnectNow;
        }

        static class Factory
        implements com.datastax.driver.core.ConvictionPolicy$Factory {
            Factory() {
            }

            @Override
            public ConvictionPolicy create(Host host, ReconnectionPolicy reconnectionPolicy) {
                return new DefaultConvictionPolicy(host, reconnectionPolicy);
            }
        }
    }

    static interface Factory {
        public ConvictionPolicy create(Host var1, ReconnectionPolicy var2);
    }
}

