/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;

public class Indexes
implements Iterable<IndexMetadata> {
    private final ImmutableMap<String, IndexMetadata> indexesByName;
    private final ImmutableMap<UUID, IndexMetadata> indexesById;

    private Indexes(Builder builder) {
        this.indexesByName = builder.indexesByName.build();
        this.indexesById = builder.indexesById.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Indexes none() {
        return Indexes.builder().build();
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return ((ImmutableCollection)this.indexesByName.values()).iterator();
    }

    public int size() {
        return this.indexesByName.size();
    }

    public boolean isEmpty() {
        return this.indexesByName.isEmpty();
    }

    public Optional<IndexMetadata> get(String name) {
        return Optional.ofNullable(this.indexesByName.get(name));
    }

    public boolean has(String name) {
        return this.indexesByName.containsKey(name);
    }

    public Optional<IndexMetadata> get(UUID id) {
        return Optional.ofNullable(this.indexesById.get(id));
    }

    public boolean has(UUID id) {
        return this.indexesById.containsKey(id);
    }

    public Indexes with(IndexMetadata index) {
        if (this.get(index.name).isPresent()) {
            throw new IllegalStateException(String.format("Index %s already exists", index.name));
        }
        return Indexes.builder().add(this).add(index).build();
    }

    public Indexes without(String name) {
        IndexMetadata index = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Index %s doesn't exist", name)));
        return Indexes.builder().add(Iterables.filter(this, v -> v != index)).build();
    }

    public Indexes replace(IndexMetadata index) {
        return this.without(index.name).with(index);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Indexes && this.indexesByName.equals(((Indexes)o).indexesByName);
    }

    public int hashCode() {
        return this.indexesByName.hashCode();
    }

    public String toString() {
        return ((AbstractCollection)this.indexesByName.values()).toString();
    }

    public static String getAvailableIndexName(String ksName, String cfName, String indexNameRoot) {
        String baseName;
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(ksName);
        Set<Object> existingNames = ksm == null ? new HashSet() : ksm.existingIndexNames(null);
        String acceptedName = baseName = IndexMetadata.getDefaultIndexName(cfName, indexNameRoot);
        int i = 0;
        while (existingNames.contains(acceptedName)) {
            acceptedName = baseName + '_' + ++i;
        }
        return acceptedName;
    }

    public static final class Builder {
        final ImmutableMap.Builder<String, IndexMetadata> indexesByName = new ImmutableMap.Builder();
        final ImmutableMap.Builder<UUID, IndexMetadata> indexesById = new ImmutableMap.Builder();

        private Builder() {
        }

        public Indexes build() {
            return new Indexes(this);
        }

        public Builder add(IndexMetadata index) {
            this.indexesByName.put(index.name, index);
            this.indexesById.put(index.id, index);
            return this;
        }

        public Builder add(Iterable<IndexMetadata> indexes) {
            indexes.forEach(this::add);
            return this;
        }
    }
}

