/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.nio.ByteBuffer;
import org.caffinitas.ohc.DirectValueAccess;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

class DirectValueAccessImpl
implements DirectValueAccess {
    private final long hashEntryAdr;
    boolean closed;
    private final ByteBuffer buffer;

    DirectValueAccessImpl(long hashEntryAdr, boolean readOnly) {
        this(hashEntryAdr, HashEntries.getKeyLen(hashEntryAdr), HashEntries.getValueLen(hashEntryAdr), readOnly);
    }

    DirectValueAccessImpl(long hashEntryAdr, long keyLen, long valueLen, boolean readOnly) {
        this.hashEntryAdr = hashEntryAdr;
        this.buffer = Uns.directBufferFor(hashEntryAdr, 56L + Util.roundUpTo8(keyLen), valueLen, readOnly);
    }

    @Override
    public ByteBuffer buffer() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        return this.buffer;
    }

    @Override
    public void close() {
        this.deref();
    }

    private void deref() {
        if (!this.closed) {
            this.closed = true;
            HashEntries.dereference(this.hashEntryAdr);
        }
    }
}

