/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import org.hawkular.metrics.model.AvailabilityBucketPoint;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;

final class AvailabilityDataPointCollector {
    private final Buckets buckets;
    private final long bucketStart;
    private DataPoint<AvailabilityType> previous;
    private long downtimeDuration;
    private long lastDowntime;
    private long downtimeCount;

    AvailabilityDataPointCollector(Buckets buckets, int bucketIndex) {
        this.buckets = buckets;
        this.bucketStart = buckets.getBucketStart(bucketIndex);
    }

    void increment(DataPoint<AvailabilityType> dataPoint) {
        long timestamp = dataPoint.getTimestamp();
        AvailabilityType value = dataPoint.getValue();
        if (this.previous != null && timestamp <= this.previous.getTimestamp()) {
            throw new IllegalStateException("Expected stream sorted in time ascending order");
        }
        if (this.previous == null) {
            if (value == AvailabilityType.DOWN) {
                this.downtimeDuration += timestamp - this.bucketStart;
                this.lastDowntime = timestamp;
                ++this.downtimeCount;
            }
        } else if (value == AvailabilityType.DOWN) {
            this.lastDowntime = timestamp;
            if (this.previous.getValue() == AvailabilityType.DOWN) {
                this.downtimeDuration += timestamp - this.previous.getTimestamp();
            } else {
                ++this.downtimeCount;
            }
        } else if (value == AvailabilityType.UP && this.previous.getValue() == AvailabilityType.DOWN) {
            this.downtimeDuration += timestamp - this.previous.getTimestamp();
            this.lastDowntime = timestamp;
        }
        this.previous = dataPoint;
    }

    AvailabilityBucketPoint toBucketPoint() {
        long to = this.bucketStart + this.buckets.getStep();
        if (this.previous.getValue() == AvailabilityType.DOWN) {
            this.downtimeDuration += to - this.previous.getTimestamp();
            this.lastDowntime = to;
        }
        return new AvailabilityBucketPoint.Builder(this.bucketStart, to).setDowntimeDuration(this.downtimeDuration).setLastDowntime(this.lastDowntime).setUptimeRatio(1.0 - (double)this.downtimeDuration / (double)this.buckets.getStep()).setDowntimeCount(this.downtimeCount).build();
    }
}

