/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.utils.UUIDs;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.core.service.TimeUUIDUtils;
import org.hawkular.metrics.core.service.transformers.BatchStatementTransformer;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Interval;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.Tenant;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.hawkular.rx.cassandra.driver.RxSessionImpl;
import rx.Observable;

public class DataAccessImpl
implements DataAccess {
    public static final long DPART = 0L;
    private Session session;
    private RxSession rxSession;
    private PreparedStatement insertTenant;
    private PreparedStatement insertTenantOverwrite;
    private PreparedStatement findAllTenantIds;
    private PreparedStatement findAllTenantIdsFromMetricsIdx;
    private PreparedStatement findTenant;
    private PreparedStatement insertIntoMetricsIndex;
    private PreparedStatement insertIntoMetricsIndexOverwrite;
    private PreparedStatement findMetric;
    private PreparedStatement getMetricTags;
    private PreparedStatement addDataRetention;
    private PreparedStatement insertGaugeData;
    private PreparedStatement insertGaugeDataWithTags;
    private PreparedStatement insertCounterData;
    private PreparedStatement insertCounterDataWithTags;
    private PreparedStatement insertStringData;
    private PreparedStatement insertStringDataWithTags;
    private PreparedStatement findCounterDataExclusive;
    private PreparedStatement findCounterDataExclusiveWithLimit;
    private PreparedStatement findCounterDataExclusiveASC;
    private PreparedStatement findCounterDataExclusiveWithLimitASC;
    private PreparedStatement findGaugeDataByDateRangeExclusive;
    private PreparedStatement findGaugeDataByDateRangeExclusiveWithLimit;
    private PreparedStatement findGaugeDataByDateRangeExclusiveASC;
    private PreparedStatement findGaugeDataByDateRangeExclusiveWithLimitASC;
    private PreparedStatement findStringDataByDateRangeExclusive;
    private PreparedStatement findStringDataByDateRangeExclusiveWithLimit;
    private PreparedStatement findStringDataByDateRangeExclusiveASC;
    private PreparedStatement findStringDataByDateRangeExclusiveWithLimitASC;
    private PreparedStatement findAvailabilityByDateRangeInclusive;
    private PreparedStatement deleteGaugeMetric;
    private PreparedStatement insertAvailability;
    private PreparedStatement insertAvailabilityWithTags;
    private PreparedStatement findAvailabilities;
    private PreparedStatement findAvailabilitiesWithLimit;
    private PreparedStatement findAvailabilitiesASC;
    private PreparedStatement findAvailabilitiesWithLimitASC;
    private PreparedStatement updateMetricsIndex;
    private PreparedStatement addTagsToMetricsIndex;
    private PreparedStatement deleteTagsFromMetricsIndex;
    private PreparedStatement readMetricsIndex;
    private PreparedStatement updateRetentionsIndex;
    private PreparedStatement findDataRetentions;
    private PreparedStatement insertMetricsTagsIndex;
    private PreparedStatement deleteMetricsTagsIndex;
    private PreparedStatement findMetricsByTagName;
    private PreparedStatement findMetricsByTagNameValue;

    public DataAccessImpl(Session session) {
        this.session = session;
        this.rxSession = new RxSessionImpl(session);
        this.initPreparedStatements();
    }

    protected void initPreparedStatements() {
        this.insertTenant = this.session.prepare("INSERT INTO tenants (id, retentions) VALUES (?, ?) IF NOT EXISTS");
        this.insertTenantOverwrite = this.session.prepare("INSERT INTO tenants (id, retentions) VALUES (?, ?)");
        this.findAllTenantIds = this.session.prepare("SELECT DISTINCT id FROM tenants");
        this.findAllTenantIdsFromMetricsIdx = this.session.prepare("SELECT DISTINCT tenant_id, type FROM metrics_idx");
        this.findTenant = this.session.prepare("SELECT id, retentions FROM tenants WHERE id = ?");
        this.findMetric = this.session.prepare("SELECT metric, tags, data_retention FROM metrics_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.getMetricTags = this.session.prepare("SELECT tags FROM metrics_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.addDataRetention = this.session.prepare("UPDATE data SET data_retention = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ?");
        this.insertIntoMetricsIndex = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric, data_retention, tags) VALUES (?, ?, ?, ?, ?) IF NOT EXISTS");
        this.insertIntoMetricsIndexOverwrite = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric, data_retention, tags) VALUES (?, ?, ?, ?, ?) ");
        this.updateMetricsIndex = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric) VALUES (?, ?, ?)");
        this.addTagsToMetricsIndex = this.session.prepare("UPDATE metrics_idx SET tags = tags + ? WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.deleteTagsFromMetricsIndex = this.session.prepare("UPDATE metrics_idx SET tags = tags - ?WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.readMetricsIndex = this.session.prepare("SELECT metric, tags, data_retention FROM metrics_idx WHERE tenant_id = ? AND type = ?");
        this.insertGaugeData = this.session.prepare("UPDATE data USING TTL ? SET n_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertGaugeDataWithTags = this.session.prepare("UPDATE data USING TTL ? SET n_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertStringData = this.session.prepare("UPDATE data USING TTL ? SET s_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertStringDataWithTags = this.session.prepare("UPDATE data USING TTL ? SET s_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertCounterData = this.session.prepare("UPDATE data USING TTL ? SET l_value = ?WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertCounterDataWithTags = this.session.prepare("UPDATE data USING TTL ? SET l_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.findGaugeDataByDateRangeExclusive = this.session.prepare("SELECT time, data_retention, n_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.findGaugeDataByDateRangeExclusiveWithLimit = this.session.prepare("SELECT time, data_retention, n_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? LIMIT ?");
        this.findGaugeDataByDateRangeExclusiveASC = this.session.prepare("SELECT time, data_retention, n_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findGaugeDataByDateRangeExclusiveWithLimitASC = this.session.prepare("SELECT time, data_retention, n_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC LIMIT ?");
        this.findStringDataByDateRangeExclusive = this.session.prepare("SELECT time, data_retention, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.findStringDataByDateRangeExclusiveWithLimit = this.session.prepare("SELECT time, data_retention, s_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? LIMIT ?");
        this.findStringDataByDateRangeExclusiveASC = this.session.prepare("SELECT time, data_retention, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findStringDataByDateRangeExclusiveWithLimitASC = this.session.prepare("SELECT time, data_retention, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC LIMIT ?");
        this.findCounterDataExclusive = this.session.prepare("SELECT time, data_retention, l_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ");
        this.findCounterDataExclusiveWithLimit = this.session.prepare("SELECT time, data_retention, l_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  LIMIT ?");
        this.findCounterDataExclusiveASC = this.session.prepare("SELECT time, data_retention, l_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findCounterDataExclusiveWithLimitASC = this.session.prepare("SELECT time, data_retention, l_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  ORDER BY time ASC LIMIT ?");
        this.findAvailabilityByDateRangeInclusive = this.session.prepare("SELECT time, data_retention, availability, WRITETIME(availability) FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time <= ?");
        this.deleteGaugeMetric = this.session.prepare("DELETE FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ?");
        this.insertAvailability = this.session.prepare("UPDATE data USING TTL ? SET availability = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertAvailabilityWithTags = this.session.prepare("UPDATE data USING TTL ? SET availability = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.findAvailabilities = this.session.prepare("SELECT time, data_retention, availability, tags  FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ");
        this.findAvailabilitiesWithLimit = this.session.prepare("SELECT time, data_retention, availability, tags  FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  LIMIT ?");
        this.findAvailabilitiesASC = this.session.prepare("SELECT time, data_retention, availability, tags  FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  ORDER BY time ASC");
        this.findAvailabilitiesWithLimitASC = this.session.prepare("SELECT time, data_retention, availability, tags  FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  ORDER BY time ASC LIMIT ?");
        this.updateRetentionsIndex = this.session.prepare("INSERT INTO retentions_idx (tenant_id, type, metric, retention) VALUES (?, ?, ?, ?)");
        this.findDataRetentions = this.session.prepare("SELECT tenant_id, type, metric, retention FROM retentions_idx WHERE tenant_id = ? AND type = ?");
        this.insertMetricsTagsIndex = this.session.prepare("INSERT INTO metrics_tags_idx (tenant_id, tname, tvalue, type, metric) VALUES (?, ?, ?, ?, ?)");
        this.deleteMetricsTagsIndex = this.session.prepare("DELETE FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ? AND tvalue = ? AND type = ? AND metric = ?");
        this.findMetricsByTagName = this.session.prepare("SELECT type, metric, tvalue FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ?");
        this.findMetricsByTagNameValue = this.session.prepare("SELECT tenant_id, type, metric FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ? AND tvalue = ?");
    }

    @Override
    public Observable<ResultSet> insertTenant(Tenant tenant, boolean overwrite) {
        Map<String, Integer> retentions = tenant.getRetentionSettings().entrySet().stream().collect(Collectors.toMap(entry -> ((MetricType)entry.getKey()).getText(), Map.Entry::getValue));
        if (overwrite) {
            return this.rxSession.execute((Statement)this.insertTenantOverwrite.bind(tenant.getId(), retentions));
        }
        return this.rxSession.execute((Statement)this.insertTenant.bind(tenant.getId(), retentions));
    }

    @Override
    public Observable<Row> findAllTenantIds() {
        return this.rxSession.executeAndFetch((Statement)this.findAllTenantIds.bind()).concatWith(this.rxSession.executeAndFetch((Statement)this.findAllTenantIdsFromMetricsIdx.bind()));
    }

    @Override
    public Observable<Row> findTenant(String id) {
        return this.rxSession.executeAndFetch((Statement)this.findTenant.bind(id));
    }

    @Override
    public <T> ResultSetFuture insertMetricInMetricsIndex(Metric<T> metric, boolean overwrite) {
        MetricId<T> metricId = metric.getMetricId();
        if (overwrite) {
            return this.session.executeAsync(this.insertIntoMetricsIndexOverwrite.bind(metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), metric.getDataRetention(), metric.getTags()));
        }
        return this.session.executeAsync(this.insertIntoMetricsIndex.bind(metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), metric.getDataRetention(), metric.getTags()));
    }

    @Override
    public <T> Observable<Row> findMetric(MetricId<T> id) {
        return this.rxSession.executeAndFetch((Statement)this.findMetric.bind(id.getTenantId(), id.getType().getCode(), id.getName()));
    }

    @Override
    public <T> Observable<Row> getMetricTags(MetricId<T> id) {
        return this.rxSession.executeAndFetch((Statement)this.getMetricTags.bind(id.getTenantId(), id.getType().getCode(), id.getName()));
    }

    @Override
    public <T> Observable<ResultSet> addDataRetention(Metric<T> metric) {
        MetricId<T> metricId = metric.getMetricId();
        return this.rxSession.execute((Statement)this.addDataRetention.bind(metric.getDataRetention(), metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L));
    }

    @Override
    public <T> Observable<ResultSet> addTags(Metric<T> metric, Map<String, String> tags) {
        MetricId<T> metricId = metric.getMetricId();
        BoundStatement stmt = this.addTagsToMetricsIndex.bind(tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName());
        return this.rxSession.execute((Statement)stmt);
    }

    @Override
    public <T> Observable<ResultSet> deleteTags(Metric<T> metric, Set<String> tags) {
        MetricId<T> metricId = metric.getMetricId();
        BoundStatement stmt = this.deleteTagsFromMetricsIndex.bind(tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName());
        return this.rxSession.execute((Statement)stmt);
    }

    @Override
    public <T> Observable<Integer> updateMetricsIndex(Observable<Metric<T>> metrics) {
        return metrics.map(Metric::getMetricId).map(id -> this.updateMetricsIndex.bind(id.getTenantId(), id.getType().getCode(), id.getName())).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    @Override
    public <T> Observable<Row> findMetricsInMetricsIndex(String tenantId, MetricType<T> type) {
        return this.rxSession.executeAndFetch((Statement)this.readMetricsIndex.bind(tenantId, type.getCode()));
    }

    @Override
    public Observable<Integer> insertGaugeData(Metric<Double> gauge, int ttl) {
        return Observable.from(gauge.getDataPoints()).map(dataPoint -> {
            if (dataPoint.getTags().isEmpty()) {
                return this.bindDataPoint(this.insertGaugeData, gauge, dataPoint.getValue(), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertGaugeDataWithTags, gauge, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
        }).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    @Override
    public Observable<Integer> insertStringData(Metric<String> metric, int ttl, int maxSize) {
        return Observable.from(metric.getDataPoints()).map(dataPoint -> {
            if (maxSize != -1 && ((String)dataPoint.getValue()).length() > maxSize) {
                throw new IllegalArgumentException(dataPoint + " exceeds max string length of " + maxSize + " characters");
            }
            if (dataPoint.getTags().isEmpty()) {
                return this.bindDataPoint(this.insertStringData, metric, dataPoint.getValue(), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertStringDataWithTags, metric, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
        }).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    @Override
    public Observable<Integer> insertCounterData(Metric<Long> counter, int ttl) {
        return Observable.from(counter.getDataPoints()).map(dataPoint -> {
            if (dataPoint.getTags().isEmpty()) {
                return this.bindDataPoint(this.insertCounterData, counter, dataPoint.getValue(), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertCounterDataWithTags, counter, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
        }).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, long timestamp, int ttl) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(ttl, value, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, Map<String, String> tags, long timestamp, int ttl) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(ttl, value, tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    @Override
    public Observable<Row> findCounterData(MetricId<Long> id, long startTime, long endTime, int limit, Order order) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch((Statement)this.findCounterDataExclusiveASC.bind(id.getTenantId(), MetricType.COUNTER.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)));
            }
            return this.rxSession.executeAndFetch((Statement)this.findCounterDataExclusiveWithLimitASC.bind(id.getTenantId(), MetricType.COUNTER.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch((Statement)this.findCounterDataExclusive.bind(id.getTenantId(), MetricType.COUNTER.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)));
        }
        return this.rxSession.executeAndFetch((Statement)this.findCounterDataExclusiveWithLimit.bind(id.getTenantId(), MetricType.COUNTER.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit));
    }

    @Override
    public Observable<Row> findGaugeData(MetricId<Double> id, long startTime, long endTime, int limit, Order order) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch((Statement)this.findGaugeDataByDateRangeExclusiveASC.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)));
            }
            return this.rxSession.executeAndFetch((Statement)this.findGaugeDataByDateRangeExclusiveWithLimitASC.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch((Statement)this.findGaugeDataByDateRangeExclusive.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)));
        }
        return this.rxSession.executeAndFetch((Statement)this.findGaugeDataByDateRangeExclusiveWithLimit.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit));
    }

    @Override
    public Observable<Row> findStringData(MetricId<String> id, long startTime, long endTime, int limit, Order order) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch((Statement)this.findStringDataByDateRangeExclusiveASC.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)));
            }
            return this.rxSession.executeAndFetch((Statement)this.findStringDataByDateRangeExclusiveWithLimitASC.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch((Statement)this.findStringDataByDateRangeExclusive.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)));
        }
        return this.rxSession.executeAndFetch((Statement)this.findStringDataByDateRangeExclusiveWithLimit.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit));
    }

    @Override
    public Observable<Row> findAvailabilityData(MetricId<AvailabilityType> id, long startTime, long endTime, int limit, Order order) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch((Statement)this.findAvailabilitiesASC.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)));
            }
            return this.rxSession.executeAndFetch((Statement)this.findAvailabilitiesWithLimitASC.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch((Statement)this.findAvailabilities.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)));
        }
        return this.rxSession.executeAndFetch((Statement)this.findAvailabilitiesWithLimit.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit));
    }

    @Override
    public Observable<Row> findAvailabilityData(MetricId<AvailabilityType> id, long timestamp) {
        return this.rxSession.executeAndFetch((Statement)this.findAvailabilityByDateRangeInclusive.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, UUIDs.startOf(timestamp), UUIDs.endOf(timestamp)));
    }

    @Override
    public Observable<ResultSet> deleteGaugeMetric(String tenantId, String metric, Interval interval, long dpart) {
        return this.rxSession.execute((Statement)this.deleteGaugeMetric.bind(tenantId, MetricType.GAUGE.getCode(), metric, interval.toString(), dpart));
    }

    @Override
    public Observable<Integer> insertAvailabilityData(Metric<AvailabilityType> metric, int ttl) {
        return Observable.from(metric.getDataPoints()).map(dataPoint -> {
            if (dataPoint.getTags().isEmpty()) {
                return this.bindDataPoint(this.insertAvailability, metric, this.getBytes((DataPoint<AvailabilityType>)dataPoint), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertAvailabilityWithTags, metric, this.getBytes((DataPoint<AvailabilityType>)dataPoint), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
        }).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    private ByteBuffer getBytes(DataPoint<AvailabilityType> dataPoint) {
        return ByteBuffer.wrap(new byte[]{dataPoint.getValue().getCode()});
    }

    @Override
    public <T> ResultSetFuture findDataRetentions(String tenantId, MetricType<T> type) {
        return this.session.executeAsync(this.findDataRetentions.bind(tenantId, type.getCode()));
    }

    @Override
    public <T> Observable<ResultSet> updateRetentionsIndex(String tenantId, MetricType<T> type, Map<String, Integer> retentions) {
        return Observable.from(retentions.entrySet()).map(entry -> this.updateRetentionsIndex.bind(tenantId, type.getCode(), entry.getKey(), entry.getValue())).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(arg_0 -> ((RxSession)this.rxSession).execute(arg_0));
    }

    @Override
    public <T> Observable<ResultSet> insertIntoMetricsTagsIndex(Metric<T> metric, Map<String, String> tags) {
        MetricId metricId = metric.getMetricId();
        return this.tagsUpdates(tags, (name, value) -> this.insertMetricsTagsIndex.bind(metricId.getTenantId(), name, value, metricId.getType().getCode(), metricId.getName()));
    }

    @Override
    public <T> Observable<ResultSet> deleteFromMetricsTagsIndex(Metric<T> metric, Map<String, String> tags) {
        MetricId metricId = metric.getMetricId();
        return this.tagsUpdates(tags, (name, value) -> this.deleteMetricsTagsIndex.bind(metricId.getTenantId(), name, value, metricId.getType().getCode(), metricId.getName()));
    }

    private Observable<ResultSet> tagsUpdates(Map<String, String> tags, BiFunction<String, String, BoundStatement> bindVars) {
        return Observable.from(tags.entrySet()).map(entry -> (BoundStatement)bindVars.apply((String)entry.getKey(), (String)entry.getValue())).flatMap(arg_0 -> ((RxSession)this.rxSession).execute(arg_0));
    }

    @Override
    public Observable<Row> findMetricsByTagName(String tenantId, String tag) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricsByTagName.bind(tenantId, tag));
    }

    @Override
    public Observable<Row> findMetricsByTagNameValue(String tenantId, String tag, String tvalue) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricsByTagNameValue.bind(tenantId, tag, tvalue));
    }

    @Override
    public <T> ResultSetFuture updateRetentionsIndex(Metric<T> metric) {
        return this.session.executeAsync(this.updateRetentionsIndex.bind(metric.getMetricId().getTenantId(), metric.getMetricId().getType().getCode(), metric.getMetricId().getName(), metric.getDataRetention()));
    }
}

