/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Percentile;
import org.hawkular.metrics.model.TaggedBucketPoint;

public class TaggedDataPointCollector {
    private Map<String, String> tags;
    private int samples = 0;
    private Min min = new Min();
    private Mean average = new Mean();
    private Max max = new Max();
    private Sum sum = new Sum();
    private PSquarePercentile median = new PSquarePercentile(50.0);
    private List<PSquarePercentile> percentiles;

    TaggedDataPointCollector(Map<String, String> tags, List<Double> percentiles) {
        this.tags = tags;
        this.percentiles = new ArrayList<PSquarePercentile>();
        percentiles.stream().forEach(d -> this.percentiles.add(new PSquarePercentile((double)d)));
    }

    void increment(DataPoint<? extends Number> dataPoint) {
        Number value = dataPoint.getValue();
        this.min.increment(value.doubleValue());
        this.average.increment(value.doubleValue());
        this.median.increment(value.doubleValue());
        this.max.increment(value.doubleValue());
        this.sum.increment(value.doubleValue());
        ++this.samples;
        this.percentiles.stream().forEach(p -> p.increment(value.doubleValue()));
    }

    TaggedBucketPoint toBucketPoint() {
        List<Percentile> results = this.percentiles.stream().map(p -> new Percentile(p.quantile(), p.getResult())).collect(Collectors.toList());
        return new TaggedBucketPoint(this.tags, this.min.getResult(), this.average.getResult(), this.median.getResult(), this.max.getResult(), this.sum.getResult(), this.samples, results);
    }
}

