/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Preconditions;
import rx.Observable;
import rx.functions.Func0;

public class BatchStatementTransformer
implements Observable.Transformer<Statement, BatchStatement> {
    public static final int MAX_BATCH_SIZE = 10;
    public static final Func0<BatchStatement> DEFAULT_BATCH_STATEMENT_FACTORY = () -> new BatchStatement(BatchStatement.Type.UNLOGGED);
    private final Func0<BatchStatement> batchStatementFactory;
    private final int batchSize;

    public BatchStatementTransformer() {
        this(DEFAULT_BATCH_STATEMENT_FACTORY, 10);
    }

    public BatchStatementTransformer(Func0<BatchStatement> batchStatementFactory, int batchSize) {
        this.batchSize = batchSize;
        Preconditions.checkArgument(batchSize <= 10, "batchSize exceeds limit");
        this.batchStatementFactory = batchStatementFactory;
    }

    public Observable<BatchStatement> call(Observable<Statement> statements) {
        return statements.window(this.batchSize).flatMap(window -> window.collect(this.batchStatementFactory, BatchStatement::add));
    }
}

