/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.sysconfig;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import java.util.Map;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.rx.cassandra.driver.RxSession;
import rx.Observable;

public class ConfigurationService {
    private RxSession session;
    private PreparedStatement findConfiguration;
    private PreparedStatement updateConfiguration;

    public void init(RxSession session) {
        this.session = session;
        this.findConfiguration = session.getSession().prepare("SELECT name, value FROM sys_config WHERE config_id = ?");
        this.updateConfiguration = session.getSession().prepare("INSERT INTO sys_config (config_id, name, value) VALUES (?, ?, ?)");
    }

    public Observable<Configuration> load(String id) {
        return this.session.executeAndFetch((Statement)this.findConfiguration.bind(id)).toMap(row -> row.getString(0), row -> row.getString(1)).map(map -> new Configuration(id, (Map<String, String>)map));
    }

    public Observable<Void> save(Configuration configuration) {
        return Observable.from(configuration.getProperties().entrySet()).map(entry -> this.updateConfiguration.bind(configuration.getId(), entry.getKey(), entry.getValue())).collect(() -> new BatchStatement(BatchStatement.Type.UNLOGGED), BatchStatement::add).flatMap(batch -> this.session.execute((Statement)batch).map(resultSet -> null));
    }
}

