/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinPolicy
implements LoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinPolicy.class);
    private final CopyOnWriteArrayList<Host> liveHosts = new CopyOnWriteArrayList();
    private final AtomicInteger index = new AtomicInteger();
    private volatile Configuration configuration;
    private volatile boolean hasLoggedLocalCLUse;

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.liveHosts.addAll(hosts);
        this.configuration = cluster.getConfiguration();
        this.index.set(new Random().nextInt(Math.max(hosts.size(), 1)));
    }

    @Override
    public HostDistance distance(Host host) {
        return HostDistance.LOCAL;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        if (!this.hasLoggedLocalCLUse) {
            ConsistencyLevel cl;
            ConsistencyLevel consistencyLevel = cl = statement.getConsistencyLevel() == null ? this.configuration.getQueryOptions().getConsistencyLevel() : statement.getConsistencyLevel();
            if (cl.isDCLocal()) {
                this.hasLoggedLocalCLUse = true;
                logger.warn("Detected request at Consistency Level {} but the non-DC aware RoundRobinPolicy is in use. It is strongly advised to use DCAwareRoundRobinPolicy if you have multiple DCs/use DC-aware consistency levels (note: this message will only be logged once)", (Object)statement.getConsistencyLevel());
            }
        }
        final List hosts = (List)this.liveHosts.clone();
        final int startIdx = this.index.getAndIncrement();
        if (startIdx > 2147473647) {
            this.index.set(0);
        }
        return new AbstractIterator<Host>(){
            private int idx;
            private int remaining;
            {
                this.idx = startIdx;
                this.remaining = hosts.size();
            }

            @Override
            protected Host computeNext() {
                int c;
                if (this.remaining <= 0) {
                    return (Host)this.endOfData();
                }
                --this.remaining;
                if ((c = this.idx++ % hosts.size()) < 0) {
                    c += hosts.size();
                }
                return (Host)hosts.get(c);
            }
        };
    }

    @Override
    public void onUp(Host host) {
        this.liveHosts.addIfAbsent(host);
    }

    @Override
    public void onDown(Host host) {
        this.liveHosts.remove(host);
    }

    @Override
    public void onAdd(Host host) {
        this.onUp(host);
    }

    @Override
    public void onRemove(Host host) {
        this.onDown(host);
    }

    @Override
    public void close() {
    }
}

