/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cql3.statements.PropertyDefinitions;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.ReplicationParams;

public final class KeyspaceAttributes
extends PropertyDefinitions {
    private static final Set<String> validKeywords;
    private static final Set<String> obsoleteKeywords;

    public void validate() {
        this.validate(validKeywords, obsoleteKeywords);
    }

    public String getReplicationStrategyClass() {
        return this.getAllReplicationOptions().get("class");
    }

    public Map<String, String> getReplicationOptions() {
        HashMap<String, String> replication = new HashMap<String, String>(this.getAllReplicationOptions());
        replication.remove("class");
        return replication;
    }

    public Map<String, String> getAllReplicationOptions() {
        Map<String, String> replication = this.getMap(KeyspaceParams.Option.REPLICATION.toString());
        return replication == null ? Collections.emptyMap() : replication;
    }

    public KeyspaceParams asNewKeyspaceParams() {
        boolean durableWrites = this.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString(), true);
        return KeyspaceParams.create(durableWrites, this.getAllReplicationOptions());
    }

    public KeyspaceParams asAlteredKeyspaceParams(KeyspaceParams previous) {
        boolean durableWrites = this.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString(), previous.durableWrites);
        ReplicationParams replication = this.getReplicationStrategyClass() == null ? previous.replication : ReplicationParams.fromMap(this.getAllReplicationOptions());
        return new KeyspaceParams(durableWrites, replication);
    }

    static {
        ImmutableSet.Builder validBuilder = ImmutableSet.builder();
        for (KeyspaceParams.Option option : KeyspaceParams.Option.values()) {
            validBuilder.add(option.toString());
        }
        validKeywords = validBuilder.build();
        obsoleteKeywords = ImmutableSet.of();
    }
}

