/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.NoSuchElementException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.partitions.BasePartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;

public class EmptyIterators {
    public static UnfilteredPartitionIterator unfilteredPartition(CFMetaData metadata, boolean isForThrift) {
        return new EmptyUnfilteredPartitionIterator(metadata, isForThrift);
    }

    public static PartitionIterator partition() {
        return EmptyPartitionIterator.instance;
    }

    public static UnfilteredRowIterator unfilteredRow(CFMetaData metadata, DecoratedKey partitionKey, boolean isReverseOrder, Row staticRow, DeletionTime partitionDeletion) {
        PartitionColumns columns = PartitionColumns.NONE;
        if (!staticRow.isEmpty()) {
            columns = new PartitionColumns(Columns.from(staticRow.columns()), Columns.NONE);
        } else {
            staticRow = Rows.EMPTY_STATIC_ROW;
        }
        if (partitionDeletion.isLive()) {
            partitionDeletion = DeletionTime.LIVE;
        }
        return new EmptyUnfilteredRowIterator(columns, metadata, partitionKey, isReverseOrder, staticRow, partitionDeletion);
    }

    public static UnfilteredRowIterator unfilteredRow(CFMetaData metadata, DecoratedKey partitionKey, boolean isReverseOrder) {
        return new EmptyUnfilteredRowIterator(PartitionColumns.NONE, metadata, partitionKey, isReverseOrder, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE);
    }

    public static RowIterator row(CFMetaData metadata, DecoratedKey partitionKey, boolean isReverseOrder) {
        return new EmptyRowIterator(metadata, partitionKey, isReverseOrder, Rows.EMPTY_STATIC_ROW);
    }

    private static class EmptyRowIterator
    extends EmptyBaseRowIterator<Row>
    implements RowIterator {
        public EmptyRowIterator(CFMetaData metadata, DecoratedKey partitionKey, boolean isReverseOrder, Row staticRow) {
            super(PartitionColumns.NONE, metadata, partitionKey, isReverseOrder, staticRow);
        }
    }

    private static class EmptyUnfilteredRowIterator
    extends EmptyBaseRowIterator<Unfiltered>
    implements UnfilteredRowIterator {
        final DeletionTime partitionLevelDeletion;

        public EmptyUnfilteredRowIterator(PartitionColumns columns, CFMetaData metadata, DecoratedKey partitionKey, boolean isReverseOrder, Row staticRow, DeletionTime partitionLevelDeletion) {
            super(columns, metadata, partitionKey, isReverseOrder, staticRow);
            this.partitionLevelDeletion = partitionLevelDeletion;
        }

        @Override
        public boolean isEmpty() {
            return this.partitionLevelDeletion == DeletionTime.LIVE && super.isEmpty();
        }

        @Override
        public DeletionTime partitionLevelDeletion() {
            return this.partitionLevelDeletion;
        }

        @Override
        public EncodingStats stats() {
            return EncodingStats.NO_STATS;
        }
    }

    private static class EmptyBaseRowIterator<U extends Unfiltered>
    implements BaseRowIterator<U> {
        final PartitionColumns columns;
        final CFMetaData metadata;
        final DecoratedKey partitionKey;
        final boolean isReverseOrder;
        final Row staticRow;

        EmptyBaseRowIterator(PartitionColumns columns, CFMetaData metadata, DecoratedKey partitionKey, boolean isReverseOrder, Row staticRow) {
            this.columns = columns;
            this.metadata = metadata;
            this.partitionKey = partitionKey;
            this.isReverseOrder = isReverseOrder;
            this.staticRow = staticRow;
        }

        @Override
        public CFMetaData metadata() {
            return this.metadata;
        }

        @Override
        public boolean isReverseOrder() {
            return this.isReverseOrder;
        }

        @Override
        public PartitionColumns columns() {
            return this.columns;
        }

        @Override
        public DecoratedKey partitionKey() {
            return this.partitionKey;
        }

        @Override
        public Row staticRow() {
            return this.staticRow;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isEmpty() {
            return this.staticRow == Rows.EMPTY_STATIC_ROW;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public U next() {
            throw new NoSuchElementException();
        }
    }

    private static class EmptyPartitionIterator
    extends EmptyBasePartitionIterator<RowIterator>
    implements PartitionIterator {
        public static final EmptyPartitionIterator instance = new EmptyPartitionIterator();

        private EmptyPartitionIterator() {
        }
    }

    private static class EmptyUnfilteredPartitionIterator
    extends EmptyBasePartitionIterator<UnfilteredRowIterator>
    implements UnfilteredPartitionIterator {
        final CFMetaData metadata;
        final boolean isForThrift;

        public EmptyUnfilteredPartitionIterator(CFMetaData metadata, boolean isForThrift) {
            this.metadata = metadata;
            this.isForThrift = isForThrift;
        }

        @Override
        public boolean isForThrift() {
            return this.isForThrift;
        }

        @Override
        public CFMetaData metadata() {
            return this.metadata;
        }
    }

    private static class EmptyBasePartitionIterator<R extends BaseRowIterator<?>>
    implements BasePartitionIterator<R> {
        EmptyBasePartitionIterator() {
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public R next() {
            throw new NoSuchElementException();
        }
    }
}

