/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.ReplicationAwareTokenAllocator;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocator;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAllocation {
    private static final Logger logger = LoggerFactory.getLogger(TokenAllocation.class);

    public static Collection<Token> allocateTokens(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, InetAddress endpoint, int numTokens) {
        StrategyAdapter strategy = TokenAllocation.getStrategy(tokenMetadata, rs, endpoint);
        Collection<Token> tokens = TokenAllocation.create(tokenMetadata, strategy).addUnit(endpoint, numTokens);
        tokens = TokenAllocation.adjustForCrossDatacenterClashes(tokenMetadata, strategy, tokens);
        if (logger.isWarnEnabled()) {
            logger.warn("Selected tokens {}", (Object)tokens);
            SummaryStatistics os = TokenAllocation.replicatedOwnershipStats(tokenMetadata, rs, endpoint);
            TokenMetadata tokenMetadataCopy = tokenMetadata.cloneOnlyTokenMap();
            tokenMetadataCopy.updateNormalTokens(tokens, endpoint);
            SummaryStatistics ns = TokenAllocation.replicatedOwnershipStats(tokenMetadataCopy, rs, endpoint);
            logger.warn("Replicated node load in datacentre before allocation " + TokenAllocation.statToString(os));
            logger.warn("Replicated node load in datacentre after allocation " + TokenAllocation.statToString(ns));
            if (ns.getStandardDeviation() > os.getStandardDeviation()) {
                logger.warn("Unexpected growth in standard deviation after allocation.");
            }
        }
        return tokens;
    }

    private static Collection<Token> adjustForCrossDatacenterClashes(TokenMetadata tokenMetadata, StrategyAdapter strategy, Collection<Token> tokens) {
        ArrayList<Token> filtered = Lists.newArrayListWithCapacity(tokens.size());
        for (Token t : tokens) {
            while (tokenMetadata.getEndpoint(t) != null) {
                InetAddress other = tokenMetadata.getEndpoint(t);
                if (strategy.inAllocationRing(other)) {
                    throw new ConfigurationException(String.format("Allocated token %s already assigned to node %s. Is another node also allocating tokens?", t, other));
                }
                t = t.increaseSlightly();
            }
            filtered.add(t);
        }
        return filtered;
    }

    public static Map<InetAddress, Double> evaluateReplicatedOwnership(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs) {
        HashMap<InetAddress, Double> ownership = Maps.newHashMap();
        ArrayList<Token> sortedTokens = tokenMetadata.sortedTokens();
        Iterator it = sortedTokens.iterator();
        Token current = (Token)it.next();
        while (it.hasNext()) {
            Token next = (Token)it.next();
            TokenAllocation.addOwnership(tokenMetadata, rs, current, next, ownership);
            current = next;
        }
        TokenAllocation.addOwnership(tokenMetadata, rs, current, (Token)sortedTokens.get(0), ownership);
        return ownership;
    }

    static void addOwnership(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, Token current, Token next, Map<InetAddress, Double> ownership) {
        double size = current.size(next);
        Token representative = current.getPartitioner().midpoint(current, next);
        Iterator<InetAddress> iterator = rs.calculateNaturalEndpoints(representative, tokenMetadata).iterator();
        while (iterator.hasNext()) {
            InetAddress n;
            Double v = ownership.get(n = iterator.next());
            ownership.put(n, v != null ? v + size : size);
        }
    }

    public static String statToString(SummaryStatistics stat) {
        return String.format("max %.2f min %.2f stddev %.4f", stat.getMax() / stat.getMean(), stat.getMin() / stat.getMean(), stat.getStandardDeviation());
    }

    public static SummaryStatistics replicatedOwnershipStats(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, InetAddress endpoint) {
        SummaryStatistics stat = new SummaryStatistics();
        StrategyAdapter strategy = TokenAllocation.getStrategy(tokenMetadata, rs, endpoint);
        for (Map.Entry<InetAddress, Double> en : TokenAllocation.evaluateReplicatedOwnership(tokenMetadata, rs).entrySet()) {
            if (!strategy.inAllocationRing(en.getKey())) continue;
            stat.addValue(en.getValue() / (double)tokenMetadata.getTokens(en.getKey()).size());
        }
        return stat;
    }

    static TokenAllocator<InetAddress> create(TokenMetadata tokenMetadata, StrategyAdapter strategy) {
        TreeMap<Token, InetAddress> sortedTokens = new TreeMap<Token, InetAddress>();
        for (Map.Entry<Token, InetAddress> en : tokenMetadata.getNormalAndBootstrappingTokenToEndpointMap().entrySet()) {
            if (!strategy.inAllocationRing(en.getValue())) continue;
            sortedTokens.put(en.getKey(), en.getValue());
        }
        return new ReplicationAwareTokenAllocator<InetAddress>(sortedTokens, strategy, tokenMetadata.partitioner);
    }

    static StrategyAdapter getStrategy(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, InetAddress endpoint) {
        if (rs instanceof NetworkTopologyStrategy) {
            return TokenAllocation.getStrategy(tokenMetadata, (NetworkTopologyStrategy)rs, rs.snitch, endpoint);
        }
        if (rs instanceof SimpleStrategy) {
            return TokenAllocation.getStrategy(tokenMetadata, (SimpleStrategy)rs, endpoint);
        }
        throw new ConfigurationException("Token allocation does not support replication strategy " + rs.getClass().getSimpleName());
    }

    static StrategyAdapter getStrategy(TokenMetadata tokenMetadata, SimpleStrategy rs, InetAddress endpoint) {
        final int replicas = rs.getReplicationFactor();
        return new StrategyAdapter(){

            @Override
            public int replicas() {
                return replicas;
            }

            @Override
            public Object getGroup(InetAddress unit) {
                return unit;
            }

            @Override
            public boolean inAllocationRing(InetAddress other) {
                return true;
            }
        };
    }

    static StrategyAdapter getStrategy(TokenMetadata tokenMetadata, NetworkTopologyStrategy rs, final IEndpointSnitch snitch, InetAddress endpoint) {
        final String dc = snitch.getDatacenter(endpoint);
        final int replicas = rs.getReplicationFactor(dc);
        TokenMetadata.Topology topology = tokenMetadata.getTopology();
        int racks = topology.getDatacenterRacks().get(dc).asMap().size();
        if (racks >= replicas) {
            return new StrategyAdapter(){

                @Override
                public int replicas() {
                    return replicas;
                }

                @Override
                public Object getGroup(InetAddress unit) {
                    return snitch.getRack(unit);
                }

                @Override
                public boolean inAllocationRing(InetAddress other) {
                    return dc.equals(snitch.getDatacenter(other));
                }
            };
        }
        if (racks == 1) {
            return new StrategyAdapter(){

                @Override
                public int replicas() {
                    return replicas;
                }

                @Override
                public Object getGroup(InetAddress unit) {
                    return unit;
                }

                @Override
                public boolean inAllocationRing(InetAddress other) {
                    return dc.equals(snitch.getDatacenter(other));
                }
            };
        }
        throw new ConfigurationException(String.format("Token allocation failed: the number of racks %d in datacenter %s is lower than its replication factor %d.", racks, dc, replicas));
    }

    static interface StrategyAdapter
    extends ReplicationStrategy<InetAddress> {
        public boolean inAllocationRing(InetAddress var1);
    }
}

