/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SSTableRewriter
extends Transactional.AbstractTransactional
implements Transactional {
    @VisibleForTesting
    public static boolean disableEarlyOpeningForTests = false;
    private final long preemptiveOpenInterval;
    private final long maxAge;
    private long repairedAt = -1L;
    private final LifecycleTransaction transaction;
    private final List<SSTableReader> preparedForCommit = new ArrayList<SSTableReader>();
    private long currentlyOpenedEarlyAt;
    private final List<SSTableWriter> writers = new ArrayList<SSTableWriter>();
    private final boolean keepOriginals;
    private SSTableWriter writer;
    private Map<DecoratedKey, RowIndexEntry> cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
    private boolean throwEarly;
    private boolean throwLate;

    @Deprecated
    public SSTableRewriter(LifecycleTransaction transaction, long maxAge, boolean isOffline) {
        this(transaction, maxAge, isOffline, true);
    }

    @Deprecated
    public SSTableRewriter(LifecycleTransaction transaction, long maxAge, boolean isOffline, boolean shouldOpenEarly) {
        this(transaction, maxAge, SSTableRewriter.calculateOpenInterval(shouldOpenEarly), false);
    }

    @VisibleForTesting
    public SSTableRewriter(LifecycleTransaction transaction, long maxAge, long preemptiveOpenInterval, boolean keepOriginals) {
        this.transaction = transaction;
        this.maxAge = maxAge;
        this.keepOriginals = keepOriginals;
        this.preemptiveOpenInterval = preemptiveOpenInterval;
    }

    @Deprecated
    public static SSTableRewriter constructKeepingOriginals(LifecycleTransaction transaction, boolean keepOriginals, long maxAge, boolean isOffline) {
        return SSTableRewriter.constructKeepingOriginals(transaction, keepOriginals, maxAge);
    }

    public static SSTableRewriter constructKeepingOriginals(LifecycleTransaction transaction, boolean keepOriginals, long maxAge) {
        return new SSTableRewriter(transaction, maxAge, SSTableRewriter.calculateOpenInterval(true), keepOriginals);
    }

    public static SSTableRewriter constructWithoutEarlyOpening(LifecycleTransaction transaction, boolean keepOriginals, long maxAge) {
        return new SSTableRewriter(transaction, maxAge, SSTableRewriter.calculateOpenInterval(false), keepOriginals);
    }

    private static long calculateOpenInterval(boolean shouldOpenEarly) {
        long interval = (long)DatabaseDescriptor.getSSTablePreempiveOpenIntervalInMB() * 0x100000L;
        if (disableEarlyOpeningForTests || !shouldOpenEarly || interval < 0L) {
            interval = Long.MAX_VALUE;
        }
        return interval;
    }

    public SSTableWriter currentWriter() {
        return this.writer;
    }

    public RowIndexEntry append(UnfilteredRowIterator partition) {
        DecoratedKey key = partition.partitionKey();
        this.maybeReopenEarly(key);
        RowIndexEntry index = this.writer.append(partition);
        if (!this.transaction.isOffline() && index != null) {
            boolean save = false;
            for (SSTableReader reader : this.transaction.originals()) {
                if (reader.getCachedPosition(key, false) == null) continue;
                save = true;
                break;
            }
            if (save) {
                this.cachedKeys.put(key, index);
            }
        }
        return index;
    }

    public RowIndexEntry tryAppend(UnfilteredRowIterator partition) {
        this.writer.mark();
        try {
            return this.append(partition);
        }
        catch (Throwable t) {
            this.writer.resetAndTruncate();
            throw t;
        }
    }

    private void maybeReopenEarly(DecoratedKey key) {
        if (this.writer.getFilePointer() - this.currentlyOpenedEarlyAt > this.preemptiveOpenInterval) {
            if (this.transaction.isOffline()) {
                for (SSTableReader reader : this.transaction.originals()) {
                    RowIndexEntry index = reader.getPosition(key, SSTableReader.Operator.GE);
                    CLibrary.trySkipCache(reader.getFilename(), 0L, index == null ? 0L : index.position);
                }
            } else {
                SSTableReader reader = this.writer.setMaxDataAge(this.maxAge).openEarly();
                if (reader != null) {
                    this.transaction.update(reader, false);
                    this.currentlyOpenedEarlyAt = this.writer.getFilePointer();
                    this.moveStarts(reader, reader.last);
                    this.transaction.checkpoint();
                }
            }
        }
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        for (SSTableWriter writer : this.writers) {
            accumulate = writer.abort(accumulate);
        }
        accumulate = this.transaction.abort(accumulate);
        return accumulate;
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        for (SSTableWriter writer : this.writers) {
            accumulate = writer.commit(accumulate);
        }
        accumulate = this.transaction.commit(accumulate);
        return accumulate;
    }

    private void moveStarts(SSTableReader newReader, DecoratedKey lowerbound) {
        if (this.transaction.isOffline()) {
            return;
        }
        if (this.preemptiveOpenInterval == Long.MAX_VALUE) {
            return;
        }
        ArrayList<DecoratedKey> invalidateKeys = new ArrayList<DecoratedKey>();
        invalidateKeys.addAll(this.cachedKeys.keySet());
        newReader.setupOnline();
        for (Map.Entry<DecoratedKey, RowIndexEntry> cacheKey : this.cachedKeys.entrySet()) {
            newReader.cacheKey(cacheKey.getKey(), cacheKey.getValue());
        }
        this.cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
        for (SSTableReader sstable : this.transaction.originals()) {
            SSTableReader latest = this.transaction.current(sstable);
            if (latest.first.compareTo(lowerbound) > 0) continue;
            InvalidateKeys runOnClose = new InvalidateKeys(latest, invalidateKeys);
            if (lowerbound.compareTo(latest.last) >= 0) {
                if (this.transaction.isObsolete(latest)) continue;
                latest.runOnClose(runOnClose);
                this.transaction.obsolete(latest);
                continue;
            }
            DecoratedKey newStart = latest.firstKeyBeyond(lowerbound);
            assert (newStart != null);
            SSTableReader replacement = latest.cloneWithNewStart(newStart, runOnClose);
            this.transaction.update(replacement, true);
        }
    }

    public void switchWriter(SSTableWriter newWriter) {
        if (newWriter != null) {
            this.writers.add(newWriter.setMaxDataAge(this.maxAge));
        }
        if (this.writer == null || this.writer.getFilePointer() == 0L) {
            if (this.writer != null) {
                this.writer.abort();
                this.transaction.untrackNew(this.writer);
                this.writers.remove(this.writer);
            }
            this.writer = newWriter;
            return;
        }
        if (this.preemptiveOpenInterval != Long.MAX_VALUE) {
            SSTableReader reader = this.writer.setMaxDataAge(this.maxAge).openFinalEarly();
            this.transaction.update(reader, false);
            this.moveStarts(reader, reader.last);
            this.transaction.checkpoint();
        }
        this.currentlyOpenedEarlyAt = 0L;
        this.writer = newWriter;
    }

    public SSTableRewriter setRepairedAt(long repairedAt) {
        this.repairedAt = repairedAt;
        return this;
    }

    @Override
    public List<SSTableReader> finish() {
        super.finish();
        return this.finished();
    }

    public List<SSTableReader> finished() {
        assert (this.state() == Transactional.AbstractTransactional.State.COMMITTED || this.state() == Transactional.AbstractTransactional.State.READY_TO_COMMIT);
        return this.preparedForCommit;
    }

    @Override
    protected void doPrepare() {
        this.switchWriter(null);
        if (this.throwEarly) {
            throw new RuntimeException("exception thrown early in finish, for testing");
        }
        for (SSTableWriter writer : this.writers) {
            assert (writer.getFilePointer() > 0L);
            writer.setRepairedAt(this.repairedAt).setOpenResult(true).prepareToCommit();
            SSTableReader reader = writer.finished();
            this.transaction.update(reader, false);
            this.preparedForCommit.add(reader);
        }
        this.transaction.checkpoint();
        if (this.throwLate) {
            throw new RuntimeException("exception thrown after all sstables finished, for testing");
        }
        if (!this.keepOriginals) {
            this.transaction.obsoleteOriginals();
        }
        this.transaction.prepareToCommit();
    }

    public void throwDuringPrepare(boolean earlyException) {
        if (earlyException) {
            this.throwEarly = true;
        } else {
            this.throwLate = true;
        }
    }

    private static final class InvalidateKeys
    implements Runnable {
        final List<KeyCacheKey> cacheKeys = new ArrayList<KeyCacheKey>();
        final WeakReference<InstrumentingCache<KeyCacheKey, ?>> cacheRef;

        private InvalidateKeys(SSTableReader reader, Collection<DecoratedKey> invalidate) {
            this.cacheRef = new WeakReference<InstrumentingCache<KeyCacheKey, RowIndexEntry>>(reader.getKeyCache());
            if (this.cacheRef.get() != null) {
                for (DecoratedKey key : invalidate) {
                    this.cacheKeys.add(reader.getCacheKey(key));
                }
            }
        }

        @Override
        public void run() {
            for (KeyCacheKey key : this.cacheKeys) {
                InstrumentingCache cache = (InstrumentingCache)this.cacheRef.get();
                if (cache == null) continue;
                cache.remove(key);
            }
        }
    }
}

