/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import com.datastax.driver.core.Row;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.joda.time.Duration;
import rx.Observable;

public class MetricFromFullDataRowTransformer
implements Observable.Transformer<Row, Metric<?>> {
    private final int defaultDataRetention;

    public MetricFromFullDataRowTransformer(int defaultTTL) {
        this.defaultDataRetention = (int)Duration.standardSeconds(defaultTTL).getStandardDays();
    }

    public Observable<Metric<?>> call(Observable<Row> rows) {
        return rows.map(row -> {
            MetricId metricId = new MetricId(row.getString(0), MetricType.fromCode(row.getByte(1)), row.getString(2));
            return new Metric(metricId, this.defaultDataRetention);
        });
    }
}

