/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import org.hawkular.metrics.model.Interval;

public class AggregatedValue {
    private final String type;
    private String srcMetric;
    private Interval srcMetricInterval;
    private final double value;
    private UUID timeUUID;

    public AggregatedValue(String type, double value) {
        this.type = type;
        this.value = value;
    }

    public AggregatedValue(String type, double value, String srcMetric, Interval srcMetricInterval, UUID timeUUID) {
        this.type = type;
        this.value = value;
        this.srcMetric = srcMetric;
        this.srcMetricInterval = srcMetricInterval;
        this.timeUUID = timeUUID;
    }

    public String getType() {
        return this.type;
    }

    public String getSrcMetric() {
        return this.srcMetric;
    }

    public Interval getSrcMetricInterval() {
        return this.srcMetricInterval;
    }

    public double getValue() {
        return this.value;
    }

    public UUID getTimeUUID() {
        return this.timeUUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregatedValue that = (AggregatedValue)o;
        if (Double.compare(that.value, this.value) != 0) {
            return false;
        }
        if (this.srcMetric != null ? !this.srcMetric.equals(that.srcMetric) : that.srcMetric != null) {
            return false;
        }
        if (this.srcMetricInterval != null ? !this.srcMetricInterval.equals(that.srcMetricInterval) : that.srcMetricInterval != null) {
            return false;
        }
        if (this.timeUUID != null ? !this.timeUUID.equals(that.timeUUID) : that.timeUUID != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.srcMetric != null ? this.srcMetric.hashCode() : 0);
        result = 31 * result + (this.srcMetricInterval != null ? this.srcMetricInterval.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.timeUUID != null ? this.timeUUID.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("value", this.value).add("srcMetric", this.srcMetric).add("srcMetricInterval", this.srcMetricInterval).add("timestamp", this.timeUUID).toString();
    }
}

