/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.api;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.Trigger;
import org.joda.time.Duration;
import org.joda.time.Minutes;

public class SingleExecutionTrigger
implements Trigger {
    private Long triggerTime;

    private SingleExecutionTrigger(Long delay, Long triggerTime) {
        if (delay == null && triggerTime == null) {
            this.triggerTime = DateTimeService.currentMinute().plusMinutes(1).getMillis();
        } else if (triggerTime != null) {
            this.triggerTime = DateTimeService.getTimeSlice(triggerTime, Duration.standardMinutes(1L));
        } else {
            long actualDelay = delay == null ? Minutes.ONE.toStandardDuration().getMillis() : delay.longValue();
            this.triggerTime = DateTimeService.getTimeSlice(DateTimeService.now.get().getMillis() + delay, Duration.standardMinutes(1L));
        }
    }

    public SingleExecutionTrigger(long triggerTime) {
        this.triggerTime = triggerTime;
    }

    @Override
    public long getTriggerTime() {
        return this.triggerTime;
    }

    @Override
    public Trigger nextTrigger() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleExecutionTrigger that = (SingleExecutionTrigger)o;
        return Objects.equals(this.triggerTime, that.triggerTime);
    }

    public int hashCode() {
        return Objects.hash(this.triggerTime);
    }

    public String toString() {
        return "SingleExecutionTrigger{triggerTime=" + this.triggerTime + '}';
    }

    public static class Builder {
        private Long delay;
        private Long triggerTime;

        public Builder withDelay(long delay, TimeUnit timeUnit) {
            this.delay = TimeUnit.MILLISECONDS.convert(delay, timeUnit);
            return this;
        }

        public Builder withTriggerTime(long time) {
            this.triggerTime = time;
            return this;
        }

        public SingleExecutionTrigger build() {
            return new SingleExecutionTrigger(this.delay, this.triggerTime);
        }
    }
}

