/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.Helpers;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.LogTransaction;
import org.apache.cassandra.db.lifecycle.SSTableIntervalTree;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.MemtableDiscardedNotification;
import org.apache.cassandra.notifications.MemtableRenewedNotification;
import org.apache.cassandra.notifications.MemtableSwitchedNotification;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableDeletingNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.notifications.SSTableRepairStatusChanged;
import org.apache.cassandra.notifications.TruncationNotification;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracker {
    private static final Logger logger = LoggerFactory.getLogger(Tracker.class);
    public final Collection<INotificationConsumer> subscribers = new CopyOnWriteArrayList<INotificationConsumer>();
    public final ColumnFamilyStore cfstore;
    final AtomicReference<View> view;
    public final boolean loadsstables;

    public Tracker(ColumnFamilyStore cfstore, boolean loadsstables) {
        this.cfstore = cfstore;
        this.view = new AtomicReference();
        this.loadsstables = loadsstables;
        this.reset();
    }

    public LifecycleTransaction tryModify(SSTableReader sstable, OperationType operationType) {
        return this.tryModify(Collections.singleton(sstable), operationType);
    }

    public LifecycleTransaction tryModify(Iterable<SSTableReader> sstables, OperationType operationType) {
        if (Iterables.isEmpty(sstables)) {
            return new LifecycleTransaction(this, operationType, sstables);
        }
        if (null == this.apply(View.permitCompacting(sstables), View.updateCompacting(Tracker.emptySet(), sstables))) {
            return null;
        }
        return new LifecycleTransaction(this, operationType, sstables);
    }

    Pair<View, View> apply(Function<View, View> function) {
        return this.apply(Predicates.alwaysTrue(), function);
    }

    Throwable apply(Function<View, View> function, Throwable accumulate) {
        try {
            this.apply(function);
        }
        catch (Throwable t) {
            accumulate = Throwables.merge(accumulate, t);
        }
        return accumulate;
    }

    Pair<View, View> apply(Predicate<View> permit, Function<View, View> function) {
        View updated;
        View cur;
        do {
            if (permit.apply(cur = this.view.get())) continue;
            return null;
        } while (!this.view.compareAndSet(cur, updated = function.apply(cur)));
        return Pair.create(cur, updated);
    }

    Throwable updateSizeTracking(Iterable<SSTableReader> oldSSTables, Iterable<SSTableReader> newSSTables, Throwable accumulate) {
        if (this.isDummy()) {
            return accumulate;
        }
        long add = 0L;
        for (SSTableReader sstable : newSSTables) {
            if (logger.isTraceEnabled()) {
                logger.trace("adding {} to list of files tracked for {}.{}", sstable.descriptor, this.cfstore.keyspace.getName(), this.cfstore.name);
            }
            try {
                add += sstable.bytesOnDisk();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        long subtract = 0L;
        for (SSTableReader sstable : oldSSTables) {
            if (logger.isTraceEnabled()) {
                logger.trace("removing {} from list of files tracked for {}.{}", sstable.descriptor, this.cfstore.keyspace.getName(), this.cfstore.name);
            }
            try {
                subtract += sstable.bytesOnDisk();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        StorageMetrics.load.inc(add - subtract);
        this.cfstore.metric.liveDiskSpaceUsed.inc(add - subtract);
        this.cfstore.metric.totalDiskSpaceUsed.inc(add);
        return accumulate;
    }

    public void addInitialSSTables(Iterable<SSTableReader> sstables) {
        if (!this.isDummy()) {
            Helpers.setupOnline(sstables);
        }
        this.apply(View.updateLiveSet(Tracker.emptySet(), sstables));
        Throwables.maybeFail(this.updateSizeTracking(Tracker.emptySet(), sstables, null));
    }

    public void addSSTables(Iterable<SSTableReader> sstables) {
        this.addInitialSSTables(sstables);
        this.maybeIncrementallyBackup(sstables);
        this.notifyAdded(sstables);
    }

    @VisibleForTesting
    public void reset() {
        this.view.set(new View(!this.isDummy() ? ImmutableList.of(new Memtable(this.cfstore)) : Collections.emptyList(), ImmutableList.of(), Collections.emptyMap(), Collections.emptyMap(), SSTableIntervalTree.empty()));
    }

    public Throwable dropSSTablesIfInvalid(Throwable accumulate) {
        if (!this.isDummy() && !this.cfstore.isValid()) {
            accumulate = this.dropSSTables(accumulate);
        }
        return accumulate;
    }

    public void dropSSTables() {
        Throwables.maybeFail(this.dropSSTables(null));
    }

    public Throwable dropSSTables(Throwable accumulate) {
        return this.dropSSTables(Predicates.alwaysTrue(), OperationType.UNKNOWN, accumulate);
    }

    public Throwable dropSSTables(Predicate<SSTableReader> remove, OperationType operationType, Throwable accumulate) {
        try (LogTransaction txnLogs = new LogTransaction(operationType, this);){
            Pair<View, View> result = this.apply(view -> {
                ImmutableSet<SSTableReader> toremove = ImmutableSet.copyOf(Iterables.filter(view.sstables, Predicates.and(remove, Helpers.notIn(view.compacting))));
                return View.updateLiveSet(toremove, Tracker.emptySet()).apply((View)view);
            });
            Sets.SetView<SSTableReader> removed = Sets.difference(((View)result.left).sstables, ((View)result.right).sstables);
            assert (Iterables.all(removed, remove));
            ArrayList<LogTransaction.Obsoletion> obsoletions = new ArrayList<LogTransaction.Obsoletion>();
            accumulate = Helpers.prepareForObsoletion(removed, txnLogs, obsoletions, accumulate);
            try {
                txnLogs.finish();
                if (!removed.isEmpty()) {
                    accumulate = Helpers.markObsolete(obsoletions, accumulate);
                    accumulate = this.updateSizeTracking(removed, Tracker.emptySet(), accumulate);
                    accumulate = Refs.release(Refs.selfRefs(removed), accumulate);
                    accumulate = this.notifySSTablesChanged(removed, Collections.emptySet(), txnLogs.type(), accumulate);
                }
            }
            catch (Throwable t) {
                accumulate = Helpers.abortObsoletion(obsoletions, accumulate);
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        catch (Throwable t) {
            accumulate = Throwables.merge(accumulate, t);
        }
        return accumulate;
    }

    public void removeUnreadableSSTables(final File directory) {
        Throwables.maybeFail(this.dropSSTables(new Predicate<SSTableReader>(){

            @Override
            public boolean apply(SSTableReader reader) {
                return reader.descriptor.directory.equals(directory);
            }
        }, OperationType.UNKNOWN, null));
    }

    public Memtable getMemtableFor(OpOrder.Group opGroup, ReplayPosition replayPosition) {
        for (Memtable memtable : this.view.get().liveMemtables) {
            if (!memtable.accepts(opGroup, replayPosition)) continue;
            return memtable;
        }
        throw new AssertionError((Object)this.view.get().liveMemtables.toString());
    }

    public Memtable switchMemtable(boolean truncating) {
        Memtable newMemtable = new Memtable(this.cfstore);
        Pair<View, View> result = this.apply(View.switchMemtable(newMemtable));
        if (truncating) {
            this.notifyRenewed(newMemtable);
        } else {
            this.notifySwitched(((View)result.left).getCurrentMemtable());
        }
        return ((View)result.left).getCurrentMemtable();
    }

    public void markFlushing(Memtable memtable) {
        this.apply(View.markFlushing(memtable));
    }

    public void replaceFlushed(Memtable memtable, Iterable<SSTableReader> sstables) {
        assert (!this.isDummy());
        if (sstables == null || Iterables.isEmpty(sstables)) {
            this.apply(View.replaceFlushed(memtable, null));
            return;
        }
        sstables.forEach(SSTableReader::setupOnline);
        this.maybeIncrementallyBackup(sstables);
        this.apply(View.replaceFlushed(memtable, sstables));
        Throwable fail = this.updateSizeTracking(Tracker.emptySet(), sstables, null);
        fail = this.notifyAdded(sstables, fail);
        this.notifyDiscarded(memtable);
        if (!this.isDummy() && !this.cfstore.isValid()) {
            this.dropSSTables();
        }
        Throwables.maybeFail(fail);
    }

    public Set<SSTableReader> getCompacting() {
        return this.view.get().compacting;
    }

    public Iterable<SSTableReader> getUncompacting() {
        return this.view.get().sstables(SSTableSet.NONCOMPACTING);
    }

    public Iterable<SSTableReader> getUncompacting(Iterable<SSTableReader> candidates) {
        return this.view.get().getUncompacting(candidates);
    }

    public void maybeIncrementallyBackup(Iterable<SSTableReader> sstables) {
        if (!DatabaseDescriptor.isIncrementalBackupsEnabled()) {
            return;
        }
        for (SSTableReader sstable : sstables) {
            File backupsDir = Directories.getBackupsDirectory(sstable.descriptor);
            sstable.createLinks(FileUtils.getCanonicalPath(backupsDir));
        }
    }

    Throwable notifySSTablesChanged(Collection<SSTableReader> removed, Collection<SSTableReader> added, OperationType compactionType, Throwable accumulate) {
        SSTableListChangedNotification notification = new SSTableListChangedNotification(added, removed, compactionType);
        for (INotificationConsumer subscriber : this.subscribers) {
            try {
                subscriber.handleNotification(notification, this);
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    Throwable notifyAdded(Iterable<SSTableReader> added, Throwable accumulate) {
        SSTableAddedNotification notification = new SSTableAddedNotification(added);
        for (INotificationConsumer subscriber : this.subscribers) {
            try {
                subscriber.handleNotification(notification, this);
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    public void notifyAdded(Iterable<SSTableReader> added) {
        Throwables.maybeFail(this.notifyAdded(added, null));
    }

    public void notifySSTableRepairedStatusChanged(Collection<SSTableReader> repairStatusesChanged) {
        SSTableRepairStatusChanged notification = new SSTableRepairStatusChanged(repairStatusesChanged);
        for (INotificationConsumer subscriber : this.subscribers) {
            subscriber.handleNotification(notification, this);
        }
    }

    public void notifyDeleting(SSTableReader deleting) {
        SSTableDeletingNotification notification = new SSTableDeletingNotification(deleting);
        for (INotificationConsumer subscriber : this.subscribers) {
            subscriber.handleNotification(notification, this);
        }
    }

    public void notifyTruncated(long truncatedAt) {
        TruncationNotification notification = new TruncationNotification(truncatedAt);
        for (INotificationConsumer subscriber : this.subscribers) {
            subscriber.handleNotification(notification, this);
        }
    }

    public void notifyRenewed(Memtable renewed) {
        this.notify(new MemtableRenewedNotification(renewed));
    }

    public void notifySwitched(Memtable previous) {
        this.notify(new MemtableSwitchedNotification(previous));
    }

    public void notifyDiscarded(Memtable discarded) {
        this.notify(new MemtableDiscardedNotification(discarded));
    }

    private void notify(INotification notification) {
        for (INotificationConsumer subscriber : this.subscribers) {
            subscriber.handleNotification(notification, this);
        }
    }

    public boolean isDummy() {
        return this.cfstore == null;
    }

    public void subscribe(INotificationConsumer consumer) {
        this.subscribers.add(consumer);
    }

    public void unsubscribe(INotificationConsumer consumer) {
        this.subscribers.remove(consumer);
    }

    private static Set<SSTableReader> emptySet() {
        return Collections.emptySet();
    }

    public View getView() {
        return this.view.get();
    }
}

