/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.security.MessageDigest;
import java.util.List;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.RowIterators;
import org.apache.cassandra.db.transform.MorePartitions;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.AbstractIterator;

public abstract class PartitionIterators {
    private PartitionIterators() {
    }

    public static RowIterator getOnlyElement(PartitionIterator iter2, SinglePartitionReadCommand command) {
        RowIterator toReturn = iter2.hasNext() ? (RowIterator)iter2.next() : EmptyIterators.row(command.metadata(), command.partitionKey(), command.clusteringIndexFilter().isReversed());
        class Close
        extends Transformation {
            final /* synthetic */ PartitionIterator val$iter;

            Close(PartitionIterator partitionIterator) {
                this.val$iter = partitionIterator;
            }

            @Override
            public void onPartitionClose() {
                boolean hadNext = this.val$iter.hasNext();
                this.val$iter.close();
                assert (!hadNext);
            }
        }
        return Transformation.apply(toReturn, new Close(iter2));
    }

    public static PartitionIterator concat(List<PartitionIterator> iterators) {
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        class Extend
        implements MorePartitions<PartitionIterator> {
            int i = 1;
            final /* synthetic */ List val$iterators;

            Extend(List list) {
                this.val$iterators = list;
            }

            @Override
            public PartitionIterator moreContents() {
                if (this.i >= this.val$iterators.size()) {
                    return null;
                }
                return (PartitionIterator)this.val$iterators.get(this.i++);
            }
        }
        return MorePartitions.extend(iterators.get(0), new Extend(iterators));
    }

    public static void digest(PartitionIterator iterator, MessageDigest digest) {
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            Throwable throwable = null;
            try {
                RowIterators.digest(partition, digest);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
    }

    public static PartitionIterator singletonIterator(RowIterator iterator) {
        return new SingletonPartitionIterator(iterator);
    }

    public static void consume(PartitionIterator iterator) {
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            Throwable throwable = null;
            try {
                while (partition.hasNext()) {
                    partition.next();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
    }

    public static PartitionIterator loggingIterator(PartitionIterator iterator, String id) {
        class Logger
        extends Transformation<RowIterator> {
            final /* synthetic */ String val$id;

            Logger(String string) {
                this.val$id = string;
            }

            @Override
            public RowIterator applyToPartition(RowIterator partition) {
                return RowIterators.loggingIterator(partition, this.val$id);
            }
        }
        return Transformation.apply(iterator, new Logger(id));
    }

    private static class SingletonPartitionIterator
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final RowIterator iterator;
        private boolean returned;

        private SingletonPartitionIterator(RowIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        protected RowIterator computeNext() {
            if (this.returned) {
                return (RowIterator)this.endOfData();
            }
            this.returned = true;
            return this.iterator;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }
}

