/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.internal.CassandraIndexSearcher;
import org.apache.cassandra.index.internal.IndexEntry;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class CompositesSearcher
extends CassandraIndexSearcher {
    public CompositesSearcher(ReadCommand command, RowFilter.Expression expression, CassandraIndex index) {
        super(command, expression, index);
    }

    private boolean isMatchingEntry(DecoratedKey partitionKey, IndexEntry entry, ReadCommand command) {
        return command.selectsKey(partitionKey) && command.selectsClustering(partitionKey, entry.indexedEntryClustering);
    }

    private boolean isStaticColumn() {
        return this.index.getIndexedColumn().isStatic();
    }

    @Override
    protected UnfilteredPartitionIterator queryDataFromIndex(final DecoratedKey indexKey, final RowIterator indexHits, final ReadCommand command, final ReadExecutionController executionController) {
        assert (indexHits.staticRow() == Rows.EMPTY_STATIC_ROW);
        return new UnfilteredPartitionIterator(){
            private IndexEntry nextEntry;
            private UnfilteredRowIterator next;

            @Override
            public boolean isForThrift() {
                return command.isForThrift();
            }

            @Override
            public CFMetaData metadata() {
                return command.metadata();
            }

            @Override
            public boolean hasNext() {
                return this.prepareNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                if (this.next == null) {
                    this.prepareNext();
                }
                UnfilteredRowIterator toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private boolean prepareNext() {
                UnfilteredRowIterator dataIter;
                while (true) {
                    SinglePartitionReadCommand dataCmd;
                    if (this.next != null) {
                        return true;
                    }
                    if (this.nextEntry == null) {
                        if (!indexHits.hasNext()) {
                            return false;
                        }
                        this.nextEntry = CompositesSearcher.this.index.decodeEntry(indexKey, (Row)indexHits.next());
                    }
                    DecoratedKey partitionKey = ((CompositesSearcher)CompositesSearcher.this).index.baseCfs.decorateKey(this.nextEntry.indexedKey);
                    ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
                    if (CompositesSearcher.this.isStaticColumn()) {
                        dataCmd = SinglePartitionReadCommand.create(((CompositesSearcher)CompositesSearcher.this).index.baseCfs.metadata, command.nowInSec(), command.columnFilter(), RowFilter.NONE, DataLimits.NONE, partitionKey, new ClusteringIndexSliceFilter(Slices.ALL, false));
                        entries.add(this.nextEntry);
                        this.nextEntry = indexHits.hasNext() ? CompositesSearcher.this.index.decodeEntry(indexKey, (Row)indexHits.next()) : null;
                    } else {
                        BTreeSet.Builder<Clusterable> clusterings = BTreeSet.builder(((CompositesSearcher)CompositesSearcher.this).index.baseCfs.getComparator());
                        while (this.nextEntry != null && partitionKey.getKey().equals(this.nextEntry.indexedKey)) {
                            if (CompositesSearcher.this.isMatchingEntry(partitionKey, this.nextEntry, command)) {
                                clusterings.add(this.nextEntry.indexedEntryClustering);
                                entries.add(this.nextEntry);
                            }
                            this.nextEntry = indexHits.hasNext() ? CompositesSearcher.this.index.decodeEntry(indexKey, (Row)indexHits.next()) : null;
                        }
                        if (clusterings.isEmpty()) continue;
                        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(clusterings.build(), false);
                        dataCmd = SinglePartitionReadCommand.create(((CompositesSearcher)CompositesSearcher.this).index.baseCfs.metadata, command.nowInSec(), command.columnFilter(), command.rowFilter(), DataLimits.NONE, partitionKey, filter);
                    }
                    dataIter = CompositesSearcher.this.filterStaleEntries(dataCmd.queryMemtableAndDisk(((CompositesSearcher)CompositesSearcher.this).index.baseCfs, executionController.baseReadOpOrderGroup()), indexKey.getKey(), entries, executionController.writeOpOrderGroup(), command.nowInSec());
                    if (!dataIter.isEmpty()) break;
                    dataIter.close();
                }
                this.next = dataIter;
                return true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                indexHits.close();
                if (this.next != null) {
                    this.next.close();
                }
            }
        };
    }

    private void deleteAllEntries(List<IndexEntry> entries, OpOrder.Group writeOp, int nowInSec) {
        entries.forEach(entry -> this.index.deleteStaleEntry(entry.indexValue, entry.indexClustering, new DeletionTime(entry.timestamp, nowInSec), writeOp));
    }

    private UnfilteredRowIterator filterStaleEntries(UnfilteredRowIterator dataIter, final ByteBuffer indexValue, final List<IndexEntry> entries, final OpOrder.Group writeOp, final int nowInSec) {
        final ArrayList<IndexEntry> staleEntries = new ArrayList<IndexEntry>();
        if (!dataIter.partitionLevelDeletion().isLive()) {
            DeletionTime deletion = dataIter.partitionLevelDeletion();
            entries.forEach(e -> {
                if (deletion.deletes(e.timestamp)) {
                    staleEntries.add((IndexEntry)e);
                }
            });
        }
        UnfilteredRowIterator iteratorToReturn = null;
        final ClusteringComparator comparator = dataIter.metadata().comparator;
        if (this.isStaticColumn()) {
            if (entries.size() != 1) {
                throw new AssertionError((Object)"A partition should have at most one index within a static column index");
            }
            iteratorToReturn = dataIter;
            if (this.index.isStale(dataIter.staticRow(), indexValue, nowInSec)) {
                staleEntries.addAll(entries);
                iteratorToReturn = UnfilteredRowIterators.noRowsIterator(dataIter.metadata(), dataIter.partitionKey(), Rows.EMPTY_STATIC_ROW, dataIter.partitionLevelDeletion(), dataIter.isReverseOrder());
            }
            this.deleteAllEntries(staleEntries, writeOp, nowInSec);
        } else {
            class Transform
            extends Transformation {
                private int entriesIdx;

                Transform() {
                }

                @Override
                public Row applyToRow(Row row) {
                    IndexEntry entry = this.findEntry(row.clustering());
                    if (!CompositesSearcher.this.index.isStale(row, indexValue, nowInSec)) {
                        return row;
                    }
                    staleEntries.add(entry);
                    return null;
                }

                private IndexEntry findEntry(Clustering clustering) {
                    assert (this.entriesIdx < entries.size());
                    while (this.entriesIdx < entries.size()) {
                        IndexEntry entry = (IndexEntry)entries.get(this.entriesIdx++);
                        int cmp = comparator.compare(entry.indexedEntryClustering, clustering);
                        assert (cmp <= 0);
                        if (cmp == 0) {
                            return entry;
                        }
                        staleEntries.add(entry);
                    }
                    throw new AssertionError();
                }

                @Override
                public void onPartitionClose() {
                    CompositesSearcher.this.deleteAllEntries(staleEntries, writeOp, nowInSec);
                }
            }
            iteratorToReturn = Transformation.apply(dataIter, new Transform());
        }
        return iteratorToReturn;
    }
}

