/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ObjectSizes;

public final class IndexHelper {
    private IndexHelper() {
    }

    public static int indexFor(ClusteringPrefix name, List<IndexInfo> indexList, ClusteringComparator comparator, boolean reversed, int lastIndex) {
        int index;
        IndexInfo target = new IndexInfo(name, name, 0L, 0L, null);
        int startIdx = 0;
        List<IndexInfo> toSearch = indexList;
        if (reversed) {
            if (lastIndex < indexList.size() - 1) {
                toSearch = indexList.subList(0, lastIndex + 1);
            }
        } else if (lastIndex > 0) {
            startIdx = lastIndex;
            toSearch = indexList.subList(lastIndex, indexList.size());
        }
        return startIdx + ((index = Collections.binarySearch(toSearch, target, comparator.indexComparator(reversed))) < 0 ? -index - (reversed ? 2 : 1) : index);
    }

    public static class IndexInfo {
        private static final long EMPTY_SIZE = ObjectSizes.measure(new IndexInfo(null, null, 0L, 0L, null));
        public final long offset;
        public final long width;
        public final ClusteringPrefix firstName;
        public final ClusteringPrefix lastName;
        public final DeletionTime endOpenMarker;

        public IndexInfo(ClusteringPrefix firstName, ClusteringPrefix lastName, long offset, long width, DeletionTime endOpenMarker) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.offset = offset;
            this.width = width;
            this.endOpenMarker = endOpenMarker;
        }

        public long unsharedHeapSize() {
            return EMPTY_SIZE + this.firstName.unsharedHeapSize() + this.lastName.unsharedHeapSize() + (this.endOpenMarker == null ? 0L : this.endOpenMarker.unsharedHeapSize());
        }

        public static class Serializer {
            public static final long WIDTH_BASE = 65536L;
            private final ISerializer<ClusteringPrefix> clusteringSerializer;
            private final Version version;

            public Serializer(CFMetaData metadata, Version version, SerializationHeader header) {
                this.clusteringSerializer = metadata.serializers().indexEntryClusteringPrefixSerializer(version, header);
                this.version = version;
            }

            public void serialize(IndexInfo info, DataOutputPlus out) throws IOException {
                assert (this.version.storeRows()) : "We read old index files but we should never write them";
                this.clusteringSerializer.serialize(info.firstName, out);
                this.clusteringSerializer.serialize(info.lastName, out);
                out.writeUnsignedVInt(info.offset);
                out.writeVInt(info.width - 65536L);
                out.writeBoolean(info.endOpenMarker != null);
                if (info.endOpenMarker != null) {
                    DeletionTime.serializer.serialize(info.endOpenMarker, out);
                }
            }

            public IndexInfo deserialize(DataInputPlus in) throws IOException {
                long width;
                long offset;
                ClusteringPrefix firstName = this.clusteringSerializer.deserialize(in);
                ClusteringPrefix lastName = this.clusteringSerializer.deserialize(in);
                DeletionTime endOpenMarker = null;
                if (this.version.storeRows()) {
                    offset = in.readUnsignedVInt();
                    width = in.readVInt() + 65536L;
                    if (in.readBoolean()) {
                        endOpenMarker = DeletionTime.serializer.deserialize(in);
                    }
                } else {
                    offset = in.readLong();
                    width = in.readLong();
                }
                return new IndexInfo(firstName, lastName, offset, width, endOpenMarker);
            }

            public long serializedSize(IndexInfo info) {
                assert (this.version.storeRows()) : "We read old index files but we should never write them";
                long size = this.clusteringSerializer.serializedSize(info.firstName) + this.clusteringSerializer.serializedSize(info.lastName) + (long)TypeSizes.sizeofUnsignedVInt(info.offset) + (long)TypeSizes.sizeofVInt(info.width - 65536L) + (long)TypeSizes.sizeof(info.endOpenMarker != null);
                if (info.endOpenMarker != null) {
                    size += DeletionTime.serializer.serializedSize(info.endOpenMarker);
                }
                return size;
            }
        }
    }
}

