/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.SSLOptions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamConnectionFactory;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.tools.BulkLoadConnectionFactory;
import org.apache.cassandra.tools.BulkLoadException;
import org.apache.cassandra.tools.LoaderOptions;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.NativeSSTableLoaderClient;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class BulkLoader {
    public static void main(String[] args) throws BulkLoadException {
        LoaderOptions options = LoaderOptions.builder().parseArgs(args).build();
        BulkLoader.load(options);
    }

    public static void load(LoaderOptions options) throws BulkLoadException {
        Config.setClientMode(true);
        OutputHandler.SystemOutput handler = new OutputHandler.SystemOutput(options.verbose, options.debug);
        SSTableLoader loader = new SSTableLoader(options.directory, new ExternalClient(options.hosts, options.nativePort, options.authProvider, options.storagePort, options.sslStoragePort, options.serverEncOptions, BulkLoader.buildSSLOptions((EncryptionOptions.ClientEncryptionOptions)options.encOptions)), handler, options.connectionsPerHost);
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(options.throttle);
        DatabaseDescriptor.setInterDCStreamThroughputOutboundMegabitsPerSec(options.interDcThrottle);
        StreamResultFuture future = null;
        ProgressIndicator indicator = new ProgressIndicator();
        try {
            future = options.noProgress ? loader.stream(options.ignores, new StreamEventHandler[0]) : loader.stream(options.ignores, indicator);
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            System.err.println(e.getMessage());
            if (e.getCause() != null) {
                System.err.println(e.getCause());
            }
            e.printStackTrace(System.err);
            throw new BulkLoadException(e);
        }
        try {
            future.get();
            if (!options.noProgress) {
                indicator.printSummary(options.connectionsPerHost);
            }
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            System.err.println("Streaming to the following hosts failed:");
            System.err.println(loader.getFailedHosts());
            e.printStackTrace(System.err);
            throw new BulkLoadException(e);
        }
    }

    private static SSLOptions buildSSLOptions(EncryptionOptions.ClientEncryptionOptions clientEncryptionOptions) {
        SSLContext sslContext;
        if (!clientEncryptionOptions.enabled) {
            return null;
        }
        try {
            sslContext = SSLFactory.createSSLContext(clientEncryptionOptions, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create SSL Context.", e);
        }
        return JdkSSLOptions.builder().withSSLContext(sslContext).withCipherSuites(clientEncryptionOptions.cipher_suites).build();
    }

    public static class CmdLineOptions
    extends Options {
        public Options addOption(String opt, String longOpt, String argName, String description) {
            Option option = new Option(opt, longOpt, true, description);
            option.setArgName(argName);
            return this.addOption(option);
        }

        public Options addOption(String opt, String longOpt, String description) {
            return this.addOption(new Option(opt, longOpt, false, description));
        }
    }

    static class ExternalClient
    extends NativeSSTableLoaderClient {
        private final int storagePort;
        private final int sslStoragePort;
        private final EncryptionOptions.ServerEncryptionOptions serverEncOptions;

        public ExternalClient(Set<InetAddress> hosts, int port, AuthProvider authProvider, int storagePort, int sslStoragePort, EncryptionOptions.ServerEncryptionOptions serverEncryptionOptions, SSLOptions sslOptions) {
            super(hosts, port, authProvider, sslOptions);
            this.storagePort = storagePort;
            this.sslStoragePort = sslStoragePort;
            this.serverEncOptions = serverEncryptionOptions;
        }

        @Override
        public StreamConnectionFactory getConnectionFactory() {
            return new BulkLoadConnectionFactory(this.storagePort, this.sslStoragePort, this.serverEncOptions, false);
        }
    }

    static class ProgressIndicator
    implements StreamEventHandler {
        private long start;
        private long lastProgress;
        private long lastTime;
        private int peak = 0;
        private int totalFiles = 0;
        private final Multimap<InetAddress, SessionInfo> sessionsByHost = HashMultimap.create();

        public ProgressIndicator() {
            this.start = this.lastTime = System.nanoTime();
        }

        @Override
        public void onSuccess(StreamState finalState) {
        }

        @Override
        public void onFailure(Throwable t) {
        }

        @Override
        public synchronized void handleStreamEvent(StreamEvent event) {
            if (event.eventType == StreamEvent.Type.STREAM_PREPARED) {
                SessionInfo session = ((StreamEvent.SessionPreparedEvent)event).session;
                this.sessionsByHost.put(session.peer, session);
            } else if (event.eventType == StreamEvent.Type.FILE_PROGRESS || event.eventType == StreamEvent.Type.STREAM_COMPLETE) {
                ProgressInfo progressInfo = null;
                if (event.eventType == StreamEvent.Type.FILE_PROGRESS) {
                    progressInfo = ((StreamEvent.ProgressEvent)event).progress;
                }
                long time = System.nanoTime();
                long deltaTime = time - this.lastTime;
                StringBuilder sb = new StringBuilder();
                sb.append("\rprogress: ");
                long totalProgress = 0L;
                long totalSize = 0L;
                boolean updateTotalFiles = this.totalFiles == 0;
                for (InetAddress peer : this.sessionsByHost.keySet()) {
                    sb.append("[").append(peer).append("]");
                    for (SessionInfo session : this.sessionsByHost.get(peer)) {
                        long size = session.getTotalSizeToSend();
                        long current = 0L;
                        int completed = 0;
                        if (progressInfo != null && session.peer.equals(progressInfo.peer) && session.sessionIndex == progressInfo.sessionIndex) {
                            session.updateProgress(progressInfo);
                        }
                        for (ProgressInfo progress : session.getSendingFiles()) {
                            if (progress.isCompleted()) {
                                ++completed;
                            }
                            current += progress.currentBytes;
                        }
                        totalProgress += current;
                        totalSize += size;
                        sb.append(session.sessionIndex).append(":");
                        sb.append(completed).append("/").append(session.getTotalFilesToSend());
                        sb.append(" ").append(String.format("%-3d", size == 0L ? 100L : current * 100L / size)).append("% ");
                        if (!updateTotalFiles) continue;
                        this.totalFiles = (int)((long)this.totalFiles + session.getTotalFilesToSend());
                    }
                }
                this.lastTime = time;
                long deltaProgress = totalProgress - this.lastProgress;
                this.lastProgress = totalProgress;
                sb.append("total: ").append(totalSize == 0L ? 100L : totalProgress * 100L / totalSize).append("% ");
                sb.append(String.format("%-3d", this.mbPerSec(deltaProgress, deltaTime))).append("MB/s");
                int average = this.mbPerSec(totalProgress, time - this.start);
                if (average > this.peak) {
                    this.peak = average;
                }
                sb.append("(avg: ").append(average).append(" MB/s)");
                System.out.print(sb.toString());
            }
        }

        private int mbPerSec(long bytes, long timeInNano) {
            double bytesPerNano = (double)bytes / (double)timeInNano;
            return (int)(bytesPerNano * 1000.0 * 1000.0 * 1000.0 / 1048576.0);
        }

        private void printSummary(int connectionsPerHost) {
            long end = System.nanoTime();
            long durationMS = (end - this.start) / 1000000L;
            int average = this.mbPerSec(this.lastProgress, end - this.start);
            StringBuilder sb = new StringBuilder();
            sb.append("\nSummary statistics: \n");
            sb.append(String.format("   %-30s: %-10d%n", "Connections per host: ", connectionsPerHost));
            sb.append(String.format("   %-30s: %-10d%n", "Total files transferred: ", this.totalFiles));
            sb.append(String.format("   %-30s: %-10d%n", "Total bytes transferred: ", this.lastProgress));
            sb.append(String.format("   %-30s: %-10d%n", "Total duration (ms): ", durationMS));
            sb.append(String.format("   %-30s: %-10d%n", "Average transfer rate (MB/s): ", average));
            sb.append(String.format("   %-30s: %-10d%n", "Peak transfer rate (MB/s): ", this.peak));
            System.out.println(sb.toString());
        }
    }
}

